/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Desktop;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/images/actions/EditExternallyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.images"})
public final class EditExternallyAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.VIRTUAL_FILE)");
        VirtualFile imageFile = (VirtualFile)object;
        try {
            Desktop.getDesktop().open(imageFile.toNioPath().toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = enabled = file != null && ImageFileTypeManager.getInstance().isImage(file);
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setVisible(enabled);
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(enabled);
    }
}

