/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.util.containers.CollectionFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001bJ\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u0016\u0010 \u001a\u0004\u0018\u00010\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"J\u0016\u0010#\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0002J\u0006\u0010&\u001a\u00020\u001bJ@\u0010'\u001a\u00020\u0018\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\"\b\u0002\u0010,\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H(0/0.\u0018\u00010-R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR:\u0010\r\u001a.\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0012\u00a2\u0006\u0002\b\u00110\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/io/jsonRpc/ClientManager;", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/io/jsonRpc/ClientListener;", "exceptionHandler", "Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "options", "Lorg/jetbrains/io/webSocket/WebSocketServerOptions;", "(Lorg/jetbrains/io/jsonRpc/ClientListener;Lorg/jetbrains/io/jsonRpc/ExceptionHandler;Lorg/jetbrains/io/webSocket/WebSocketServerOptions;)V", "clientCount", "", "getClientCount", "()I", "clients", "", "Lorg/jetbrains/io/jsonRpc/Client;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getExceptionHandler", "()Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "heartbeatTimer", "Lcom/intellij/openapi/util/SimpleTimerTask;", "addClient", "", "client", "disconnectClient", "", "channel", "Lio/netty/channel/Channel;", "closeChannel", "dispose", "findClient", "predicate", "Ljava/util/function/Predicate;", "forEachClient", "procedure", "Ljava/util/function/Consumer;", "hasClients", "send", "T", "messageId", "message", "Lio/netty/buffer/ByteBuf;", "results", "", "Lorg/jetbrains/concurrency/Promise;", "Lkotlin/Pair;", "intellij.platform.builtInServer.impl"})
public final class ClientManager
implements Disposable {
    private final SimpleTimerTask heartbeatTimer;
    private final Set<Client> clients;
    private final ClientListener listener;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Set<Client> set = this.clients;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getClientCount() {
        Set<Client> set = this.clients;
        boolean bl = false;
        int n = 0;
        synchronized (set) {
            boolean bl2 = false;
            n = this.clients.size();
        }
        return n;
    }

    public final boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            Set<Client> set = this.clients;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final <T> void send(int messageId, @NotNull ByteBuf message, @Nullable List<Promise<Pair<Client, T>>> results) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.forEachClient(new Consumer<Client>(this, messageId, message, results){
            private boolean first;
            final /* synthetic */ ClientManager this$0;
            final /* synthetic */ int $messageId;
            final /* synthetic */ ByteBuf $message;
            final /* synthetic */ List $results;

            public void accept(@NotNull Client client) {
                Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
                try {
                    Promise<T> result2 = client.send(this.$messageId, this.first ? this.$message : this.$message.duplicate());
                    this.first = false;
                    List list = this.$results;
                    if (list != null) {
                        Promise<T> promise = result2;
                        Intrinsics.checkNotNull(promise);
                        list.add(promise);
                    }
                }
                catch (Throwable e) {
                    this.this$0.getExceptionHandler().exceptionCaught(e);
                }
            }
            {
                this.this$0 = this$0;
                this.$messageId = $captured_local_variable$1;
                this.$message = $captured_local_variable$2;
                this.$results = $captured_local_variable$3;
            }
        });
    }

    public static /* synthetic */ void send$default(ClientManager clientManager, int n, ByteBuf byteBuf, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = null;
        }
        clientManager.send(n, byteBuf, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disconnectClient(@NotNull Channel channel, @NotNull Client client, boolean closeChannel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Set<Client> set = this.clients;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            block9: {
                boolean bl3 = false;
                if (this.clients.remove((Object)client)) break block9;
                boolean bl4 = false;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            channel.attr(ClientManagerKt.getCLIENT()).set(null);
            if (closeChannel) {
                channel.close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
        }
        finally {
            ClientListener clientListener = this.listener;
            if (clientListener != null) {
                clientListener.disconnected(client);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forEachClient(Consumer<Client> procedure) {
        Set<Client> set = this.clients;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (Client client : this.clients) {
                procedure.accept(client);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Client findClient(@NotNull Predicate<Client> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set<Client> set = this.clients;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            Object v0;
            block4: {
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = this.clients;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Client it = (Client)((Object)element$iv);
                    boolean bl4 = false;
                    if (!predicate.test(it)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Client client = v0;
            return client;
        }
    }

    @NotNull
    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ClientManager(@Nullable ClientListener listener, @NotNull ExceptionHandler exceptionHandler, @Nullable WebSocketServerOptions options) {
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        SimpleTimer simpleTimer = SimpleTimer.getInstance();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ ClientManager this$0;

            public final void run() {
                ClientManager.access$forEachClient(this.this$0, heartbeatTimer.1.INSTANCE);
            }
            {
                this.this$0 = clientManager;
            }
        };
        WebSocketServerOptions webSocketServerOptions = options;
        if (webSocketServerOptions == null) {
            webSocketServerOptions = new WebSocketServerOptions();
        }
        SimpleTimerTask simpleTimerTask = simpleTimer.setUp(runnable, (long)webSocketServerOptions.heartbeatDelay);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTimerTask, (String)"SimpleTimer.getInstance(\u2026.heartbeatDelay.toLong())");
        this.heartbeatTimer = simpleTimerTask;
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CollectionFactory.create\u2026oryFootprintSet<Client>()");
        this.clients = set;
    }

    public /* synthetic */ ClientManager(ClientListener clientListener, ExceptionHandler exceptionHandler, WebSocketServerOptions webSocketServerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            webSocketServerOptions = null;
        }
        this(clientListener, exceptionHandler, webSocketServerOptions);
    }

    public static final /* synthetic */ void access$forEachClient(ClientManager $this, Consumer procedure) {
        $this.forEachClient(procedure);
    }
}

