/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;

public final class DateChangeListGroupingStrategy
implements ChangeListGroupingStrategy {
    @NonNls
    private final SimpleDateFormat myMonthYearFormat = new SimpleDateFormat("MMMM yyyy", Locale.ENGLISH);
    private long myTimeToRecalculateAfter;
    private Calendar myCurrentCalendar;
    private final Calendar myCalendar = Calendar.getInstance();
    private final WeekDayFormatCache myWeekDayFormatCache = new WeekDayFormatCache(this.myCalendar);
    private final MonthsCache myMonthsCache = new MonthsCache(this.myCalendar);

    public String toString() {
        return VcsBundle.message((String)"date.group.title", (Object[])new Object[0]);
    }

    @Override
    public boolean changedSinceApply() {
        return System.currentTimeMillis() > this.myTimeToRecalculateAfter;
    }

    @Override
    public void beforeStart() {
        this.myCurrentCalendar = Calendar.getInstance();
        this.myCurrentCalendar.setTimeInMillis(0L);
        this.myCurrentCalendar.set(10, 0);
        this.myCurrentCalendar.set(12, 0);
        this.myTimeToRecalculateAfter = this.myCurrentCalendar.getTimeInMillis() + 82800000L;
        this.myCurrentCalendar.setTime(new Date());
    }

    @Override
    public String getGroupName(CommittedChangeList changeList) {
        return this.getGroupName(changeList.getCommitDate());
    }

    public String getGroupName(Date date) {
        this.myCalendar.setTime(date);
        if (this.myCurrentCalendar.get(1) == this.myCalendar.get(1)) {
            if (this.myCurrentCalendar.get(6) == this.myCalendar.get(6)) {
                return VcsBundle.message((String)"date.group.today", (Object[])new Object[0]);
            }
            if (this.myCurrentCalendar.get(3) == this.myCalendar.get(3)) {
                return this.myWeekDayFormatCache.get(this.myCalendar.get(7));
            }
            if (this.myCurrentCalendar.get(3) == this.myCalendar.get(3) + 1) {
                return VcsBundle.message((String)"date.group.last.week", (Object[])new Object[0]);
            }
            return this.myMonthsCache.get(this.myCalendar.get(2));
        }
        return this.myMonthYearFormat.format(date);
    }

    @Override
    public Comparator<CommittedChangeList> getComparator() {
        return CommittedChangeListByDateComparator.DESCENDING;
    }

    private static final class WeekDayFormatCache {
        private final Int2ObjectMap<String> myCache = new Int2ObjectOpenHashMap(7);

        private WeekDayFormatCache(Calendar calendarForInit) {
            SimpleDateFormat weekdayFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
            for (int i = 1; i < 8; ++i) {
                calendarForInit.set(7, i);
                this.myCache.put(i, (Object)weekdayFormat.format(calendarForInit.getTime()));
            }
        }

        public String get(int dayOfWeek) {
            return (String)this.myCache.get(dayOfWeek);
        }
    }

    private static final class MonthsCache {
        private final Int2ObjectMap<String> myCache = new Int2ObjectOpenHashMap(12);

        private MonthsCache(Calendar calendarForInit) {
            SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            for (int i = 0; i < 12; ++i) {
                calendarForInit.set(2, i);
                this.myCache.put(i, (Object)monthFormat.format(calendarForInit.getTime()));
            }
        }

        public String get(int month) {
            return (String)this.myCache.get(month);
        }
    }
}

