/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    @NonNls
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    @NonNls
    private static final String DATE_NAME_TEMPLATE = "(date {0})";
    @NotNull
    private final Path myBasePath;
    private final boolean myIsReversePath;
    @Nullable
    private final Runnable myCancelChecker;

    private TextPatchBuilder(@NotNull Path basePath, boolean isReversePath, @Nullable Runnable cancelChecker) {
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(0);
        }
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myCancelChecker = cancelChecker;
    }

    @NotNull
    public static List<FilePatch> buildPatch(@NotNull Collection<BeforeAfter<AirContentRevision>> changes, @NotNull Path basePath, boolean reversePatch, @Nullable Runnable cancelChecker) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(1);
        }
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(2);
        }
        return new TextPatchBuilder(basePath, reversePatch, cancelChecker).build(changes);
    }

    @NotNull
    private List<FilePatch> build(@NotNull Collection<BeforeAfter<AirContentRevision>> changes) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(3);
        }
        ArrayList<FilePatch> result2 = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> c : changes) {
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            FilePatch patch;
            if (this.myCancelChecker != null) {
                this.myCancelChecker.run();
            }
            if ((patch = this.createPatch(beforeRevision = this.myIsReversePath ? (AirContentRevision)c.getAfter() : (AirContentRevision)c.getBefore(), afterRevision = this.myIsReversePath ? (AirContentRevision)c.getBefore() : (AirContentRevision)c.getAfter())) == null) continue;
            result2.add(patch);
        }
        ArrayList<FilePatch> arrayList = result2;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private FilePatch createPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null && afterRevision == null) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.getPath().isDirectory()) {
            return null;
        }
        if (afterRevision != null && afterRevision.getPath().isDirectory()) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
            return this.buildBinaryPatch(beforeRevision, afterRevision);
        }
        if (beforeRevision == null) {
            return this.buildAddedFile(afterRevision);
        }
        if (afterRevision == null) {
            return this.buildDeletedFile(beforeRevision);
        }
        return this.buildModifiedFile(beforeRevision, afterRevision);
    }

    @Nullable
    private TextFilePatch buildModifiedFile(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(5);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(6);
        }
        String beforeContent = TextPatchBuilder.getContent(beforeRevision);
        String afterContent = TextPatchBuilder.getContent(afterRevision);
        TextFilePatch patch = this.buildPatchHeading(beforeRevision, afterRevision);
        List<PatchHunk> hunks = TextPatchBuilder.buildPatchHunks(beforeContent, afterContent);
        for (PatchHunk hunk : hunks) {
            patch.addHunk(hunk);
        }
        if (hunks.isEmpty() && beforeRevision.getPath().getPath().equals(afterRevision.getPath().getPath())) {
            return null;
        }
        return patch;
    }

    @NotNull
    public static List<PatchHunk> buildPatchHunks(@NotNull String beforeContent, @NotNull String afterContent) {
        List<Range> hunkFragments;
        if (beforeContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(7);
        }
        if (afterContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(8);
        }
        if (beforeContent.equals(afterContent)) {
            List<PatchHunk> list = Collections.emptyList();
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (beforeContent.isEmpty()) {
            List<PatchHunk> list = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(afterContent, true, true));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (afterContent.isEmpty()) {
            List<PatchHunk> list = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(beforeContent, false, true));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
        List<String> beforeLines = TextPatchBuilder.tokenize(beforeContent);
        List<String> afterLines = TextPatchBuilder.tokenize(afterContent);
        boolean beforeNoNewlineAtEOF = !beforeContent.endsWith("\n");
        boolean afterNoNewlineAtEOF = !afterContent.endsWith("\n");
        List<Range> fragments = TextPatchBuilder.compareLines(beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF);
        for (int hunkStart = 0; hunkStart < fragments.size(); hunkStart += hunkFragments.size()) {
            hunkFragments = TextPatchBuilder.getAdjacentFragments(fragments, hunkStart);
            hunks.add(TextPatchBuilder.createHunk(hunkFragments, beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF));
        }
        ArrayList<PatchHunk> arrayList = hunks;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<Range> getAdjacentFragments(@NotNull List<Range> fragments, int hunkStart) {
        int hunkEnd;
        if (fragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(13);
        }
        for (hunkEnd = hunkStart + 1; hunkEnd < fragments.size(); ++hunkEnd) {
            Range lastFragment = fragments.get(hunkEnd - 1);
            Range nextFragment = fragments.get(hunkEnd);
            if (lastFragment.end1 + 3 < nextFragment.start1 - 3 && lastFragment.end2 + 3 < nextFragment.start2 - 3) break;
        }
        List<Range> list = fragments.subList(hunkStart, hunkEnd);
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static PatchHunk createHunk(@NotNull List<? extends Range> hunkFragments, @NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (hunkFragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(15);
        }
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(16);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(17);
        }
        Range first = hunkFragments.get(0);
        Range last = hunkFragments.get(hunkFragments.size() - 1);
        int contextStart1 = Math.max(first.start1 - 3, 0);
        int contextStart2 = Math.max(first.start2 - 3, 0);
        int contextEnd1 = Math.min(last.end1 + 3, beforeLines.size());
        int contextEnd2 = Math.min(last.end2 + 3, afterLines.size());
        PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
        int lastLine1 = contextStart1;
        int lastLine2 = contextStart2;
        for (Range range : hunkFragments) {
            int i;
            int start1 = range.start1;
            int start2 = range.start2;
            int end1 = range.end1;
            int end2 = range.end2;
            assert (start1 - lastLine1 == start2 - lastLine2);
            for (i = lastLine1; i < start1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
            }
            for (i = start1; i < end1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.REMOVE, i, beforeNoNewlineAtEOF);
            }
            for (i = start2; i < end2; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, afterLines, PatchLine.Type.ADD, i, afterNoNewlineAtEOF);
            }
            lastLine1 = end1;
            lastLine2 = end2;
        }
        assert (contextEnd1 - lastLine1 == contextEnd2 - lastLine2);
        for (int i = lastLine1; i < contextEnd1; ++i) {
            TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(18);
        }
        return patchHunk;
    }

    @NotNull
    private static List<Range> compareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(19);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(20);
        }
        if (!beforeNoNewlineAtEOF && !afterNoNewlineAtEOF) {
            return TextPatchBuilder.doCompareLines(beforeLines, afterLines);
        }
        int beforeLastLine = beforeLines.size() - 1;
        int afterLastLine = afterLines.size() - 1;
        List<String> beforeComparedLines = beforeNoNewlineAtEOF ? beforeLines.subList(0, beforeLastLine) : beforeLines;
        List<String> afterComparedLines = afterNoNewlineAtEOF ? afterLines.subList(0, afterLastLine) : afterLines;
        List<Range> ranges = TextPatchBuilder.doCompareLines(beforeComparedLines, afterComparedLines);
        if (beforeNoNewlineAtEOF && afterNoNewlineAtEOF) {
            if (beforeLines.get(beforeLastLine).equals(afterLines.get(afterLastLine))) {
                List<Range> list = ranges;
                if (list == null) {
                    TextPatchBuilder.$$$reportNull$$$0(21);
                }
                return list;
            }
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        if (beforeNoNewlineAtEOF) {
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine + 1, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        Range range = new Range(beforeLastLine + 1, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
        return TextPatchBuilder.appendRange(ranges, range);
    }

    @NotNull
    private static List<Range> appendRange(@NotNull List<? extends Range> ranges, @NotNull Range change) {
        if (ranges == null) {
            TextPatchBuilder.$$$reportNull$$$0(22);
        }
        if (change == null) {
            TextPatchBuilder.$$$reportNull$$$0(23);
        }
        if (ranges.isEmpty()) {
            List<Range> list = Collections.singletonList(change);
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(24);
            }
            return list;
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.end1 == change.start1 && lastRange.end2 == change.start2) {
            Range mergedChange = new Range(lastRange.start1, change.end1, lastRange.start2, change.end2);
            List list = ContainerUtil.append(ranges.subList(0, ranges.size() - 1), (Object[])new Range[]{mergedChange});
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.append(ranges, (Object[])new Range[]{change});
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static List<Range> doCompareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines) {
        ArrayList arrayList;
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(27);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(28);
        }
        try {
            FairDiffIterable iterable = ByLine.compare(beforeLines, afterLines, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            arrayList = ContainerUtil.newArrayList((Iterable)iterable.iterateChanges());
        }
        catch (DiffTooBigException e) {
            List<Range> list = Collections.singletonList(new Range(0, beforeLines.size(), 0, afterLines.size()));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(30);
            }
            return list;
        }
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    private FilePatch buildBinaryPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        assert (beforeRevision != null || afterRevision != null);
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading((FilePatch)patch, headingBeforeRevision, headingAfterRevision);
        BinaryFilePatch binaryFilePatch = patch;
        if (binaryFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(31);
        }
        return binaryFilePatch;
    }

    @NotNull
    private TextFilePatch buildAddedFile(@NotNull AirContentRevision afterRevision) throws VcsException {
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(32);
        }
        TextFilePatch result2 = this.buildPatchHeading(afterRevision, afterRevision);
        result2.setFileStatus(FileStatus.ADDED);
        String content2 = TextPatchBuilder.getContent(afterRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, true, false));
        }
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(33);
        }
        return textFilePatch;
    }

    @NotNull
    private TextFilePatch buildDeletedFile(@NotNull AirContentRevision beforeRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(34);
        }
        TextFilePatch result2 = this.buildPatchHeading(beforeRevision, beforeRevision);
        result2.setFileStatus(FileStatus.DELETED);
        String content2 = TextPatchBuilder.getContent(beforeRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, false, false));
        }
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(35);
        }
        return textFilePatch;
    }

    private static void addLineToHunk(@NotNull PatchHunk hunk, @NotNull List<String> lines, @NotNull PatchLine.Type type, int index, boolean noNewlineAtEOF) {
        if (hunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(36);
        }
        if (lines == null) {
            TextPatchBuilder.$$$reportNull$$$0(37);
        }
        if (type == null) {
            TextPatchBuilder.$$$reportNull$$$0(38);
        }
        String line = lines.get(index);
        boolean isLastLine = index == lines.size() - 1;
        PatchLine patchLine = new PatchLine(type, line);
        patchLine.setSuppressNewLine(noNewlineAtEOF && isLastLine);
        hunk.addLine(patchLine);
    }

    @NotNull
    private static PatchHunk createWholeFileHunk(@NotNull String content2, boolean isInsertion, boolean isWithEmptyFile) {
        if (content2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(39);
        }
        PatchLine.Type type = isInsertion ? PatchLine.Type.ADD : PatchLine.Type.REMOVE;
        List<String> lines = TextPatchBuilder.tokenize(content2);
        boolean noNewlineAtEOF = !content2.endsWith("\n");
        int contentStart = 0;
        int contentEnd = lines.size();
        int emptyStart = isWithEmptyFile ? 0 : -1;
        int emptyEnd = isWithEmptyFile ? 0 : -1;
        PatchHunk hunk = new PatchHunk(isInsertion ? emptyStart : contentStart, isInsertion ? emptyEnd : contentEnd, isInsertion ? contentStart : emptyStart, isInsertion ? contentEnd : emptyEnd);
        for (int i = 0; i < lines.size(); ++i) {
            TextPatchBuilder.addLineToHunk(hunk, lines, type, i, noNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(40);
        }
        return patchHunk;
    }

    @NotNull
    private TextFilePatch buildPatchHeading(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(41);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(42);
        }
        TextFilePatch result2 = new TextFilePatch(afterRevision.getCharset(), afterRevision.getLineSeparator());
        this.setPatchHeading((FilePatch)result2, beforeRevision, afterRevision);
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(43);
        }
        return textFilePatch;
    }

    private void setPatchHeading(@NotNull FilePatch result2, @NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (result2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(44);
        }
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(45);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(46);
        }
        result2.setBeforeName(this.myBasePath.relativize(beforeRevision.getPath().getPath()).toString().replace(File.separatorChar, '/'));
        result2.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result2.setAfterName(this.myBasePath.relativize(afterRevision.getPath().getPath()).toString().replace(File.separatorChar, '/'));
        result2.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }

    @NotNull
    private static String getRevisionName(@NotNull AirContentRevision revision) {
        String revisionName;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(47);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(revisionName = revision.getRevisionNumber()))) {
            String string = MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
            if (string == null) {
                TextPatchBuilder.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = MessageFormat.format(DATE_NAME_TEMPLATE, Long.toString(revision.getPath().lastModified()));
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private static String getContent(@NotNull AirContentRevision revision) throws VcsException {
        String beforeContent;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(50);
        }
        if ((beforeContent = revision.getContentAsString()) == null) {
            throw new VcsException(VcsBundle.message((String)"patch.failed.to.fetch.old.content.for.file.name.in.revision", (Object[])new Object[]{revision.getPath().getPath(), revision.getRevisionNumber()}));
        }
        String string = beforeContent;
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    private static List<String> tokenize(@NotNull String text2) {
        if (text2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(52);
        }
        List list = LineTokenizer.tokenizeIntoList((CharSequence)text2, (boolean)false, (boolean)true);
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(53);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 5: 
            case 34: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRevision";
                break;
            }
            case 6: 
            case 32: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRevision";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterContent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunkFragments";
                break;
            }
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLines";
                break;
            }
            case 17: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLines";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHunks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentFragments";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHunk";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRange";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompareLines";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBinaryPatch";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAddedFile";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeletedFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createWholeFileHunk";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHeading";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildModifiedFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHunks";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentFragments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHunk";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doCompareLines";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildAddedFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "buildDeletedFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addLineToHunk";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createWholeFileHunk";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHeading";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setPatchHeading";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

