/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project myProject;
    private final RunConfigurationBase<?> myConfiguration;
    private boolean myIsCoverageEnabled;
    private String myRunnerId;
    private CoverageRunner myCoverageRunner;
    private boolean myTrackPerTestCoverage;
    private boolean mySampling;
    private boolean myTrackTestFolders;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite myCurrentCoverageSuite;

    public CoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(0);
        }
        this.myIsCoverageEnabled = false;
        this.myTrackPerTestCoverage = true;
        this.mySampling = true;
        this.myTrackTestFolders = false;
        this.myConfiguration = configuration;
        this.myProject = configuration.getProject();
    }

    @NotNull
    public RunConfigurationBase<?> getConfiguration() {
        RunConfigurationBase<?> runConfigurationBase = this.myConfiguration;
        if (runConfigurationBase == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(1);
        }
        return runConfigurationBase;
    }

    public boolean isCoverageEnabled() {
        return this.myIsCoverageEnabled;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.myIsCoverageEnabled = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public void setSampling(boolean sampling) {
        this.mySampling = sampling;
    }

    public String getRunnerId() {
        return this.myRunnerId;
    }

    @Nullable
    public CoverageRunner getCoverageRunner() {
        return this.myCoverageRunner;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.myCoverageRunner = coverageRunner;
        this.myRunnerId = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public void coverageRunnerExtensionRemoved(@NotNull CoverageRunner runner) {
        if (runner == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(2);
        }
        if (runner.getId().equals(this.myRunnerId)) {
            this.myCoverageRunner = null;
            this.myCoverageFilePath = null;
        }
    }

    public boolean isTrackPerTestCoverage() {
        return this.myTrackPerTestCoverage;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.myTrackPerTestCoverage = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.myTrackTestFolders = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.myCurrentCoverageSuite;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.myCurrentCoverageSuite = currentCoverageSuite;
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!engine.isApplicableTo(this.myConfiguration)) continue;
            return engine.canHavePerTestCoverage(this.myConfiguration);
        }
        return false;
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration configuration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(3);
        }
        if ((configuration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) != null) {
            return true;
        }
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!engine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration configuration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(4);
        }
        if ((configuration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) == null) {
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!engine.isApplicableTo(runConfiguration)) continue;
                configuration = engine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            LOG.assertTrue(configuration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)configuration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration = configuration;
        if (coverageEnabledConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(5);
        }
        return coverageEnabledConfiguration;
    }

    @Nullable
    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myIsCoverageEnabled = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String collectLineInfoAttribute = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.myTrackPerTestCoverage = collectLineInfoAttribute == null || Boolean.valueOf(collectLineInfoAttribute) != false;
        this.mySampling = Boolean.parseBoolean(element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME, "true"));
        String trackTestFolders = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.myTrackTestFolders = trackTestFolders != null && Boolean.valueOf(trackTestFolders) != false;
        String runnerId = element.getAttributeValue(COVERAGE_RUNNER);
        if (runnerId != null) {
            this.myRunnerId = runnerId;
            this.myCoverageRunner = null;
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.myRunnerId)) continue;
                this.myCoverageRunner = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myIsCoverageEnabled) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (!this.myTrackPerTestCoverage) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (!this.mySampling) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.myTrackTestFolders) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.myCoverageRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myCoverageRunner.getId());
        } else if (this.myRunnerId != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunnerId);
        }
    }

    @Nullable
    @NonNls
    protected String createCoverageFile() {
        if (this.myCoverageRunner == null) {
            return null;
        }
        @NonNls String coverageRootPath = PathManager.getSystemPath() + File.separator + "coverage";
        String path = coverageRootPath + File.separator + FileUtil.sanitizeFileName((String)this.myProject.getName()) + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.myConfiguration.getName()) + "." + this.myCoverageRunner.getDataFileExtension();
        new File(coverageRootPath).mkdirs();
        return path;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = COVERAGE_RUNNER;
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coverageRunnerExtensionRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

