/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.changes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.jetbrains.changeReminder.ChangeReminderBundle;
import com.jetbrains.changeReminder.predict.PredictionData;
import com.jetbrains.changeReminder.predict.PredictionService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0014\u0010\u000f\u001a\u00020\b*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/changeReminder/changes/ChangeReminderBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/jetbrains/changeReminder/predict/PredictionData;", "predictionData", "predictionService", "Lcom/jetbrains/changeReminder/predict/PredictionService;", "(Lcom/jetbrains/changeReminder/predict/PredictionData;Lcom/jetbrains/changeReminder/predict/PredictionService;)V", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "appendCustomState", "state", "", "intellij.vcs.changeReminder"})
public final class ChangeReminderBrowserNode
extends ChangesBrowserNode<PredictionData> {
    private final PredictionData predictionData;
    private final PredictionService predictionService;

    private final void appendCustomState(ChangesBrowserNodeRenderer $this$appendCustomState, String state) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getCountText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"countText");
        CharSequence charSequence = string;
        boolean bl = false;
        $this$appendCustomState.append(stringBuilder.append(charSequence.length() == 0 ? FontUtil.spaceAndThinSpace() : ", ").append(state).toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(ChangeReminderBundle.message("changes.browser.node.title", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.setIcon(AllIcons.Nodes.Related);
        this.appendCount((ColoredTreeCellRenderer)renderer);
        Project project = this.predictionService.getProject();
        if (this.predictionService.isReadyToDisplay()) {
            if (this.predictionService.getInProgress()) {
                String string = ChangeReminderBundle.message("changes.browser.node.attribute.prediction.is.calculating", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ChangeReminderBundle.mes\u2026ediction.is.calculating\")");
                this.appendCustomState(renderer, string);
            }
        } else {
            String string = ChangeReminderBundle.message("changes.browser.node.attribute.git.log.is.loading", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ChangeReminderBundle.mes\u2026bute.git.log.is.loading\")");
            this.appendCustomState(renderer, string);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"changeListManager.defaultChangeList");
        LocalChangeList defaultChangeList = localChangeList;
        int predictionSize = this.predictionData.getPredictionToDisplay().size();
        renderer.setToolTipText(ChangeReminderBundle.message("changes.browser.node.prediction.tooltip.text", predictionSize, defaultChangeList.getChanges().size(), defaultChangeList.getName()));
    }

    public ChangeReminderBrowserNode(@NotNull PredictionData predictionData, @NotNull PredictionService predictionService) {
        Intrinsics.checkNotNullParameter((Object)predictionData, (String)"predictionData");
        Intrinsics.checkNotNullParameter((Object)predictionService, (String)"predictionService");
        super((Object)predictionData);
        this.predictionData = predictionData;
        this.predictionService = predictionService;
    }
}

