/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ConcurrencyUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public final class MavenArtifactDownloader {
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final AtomicInteger num = new AtomicInteger();

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                1.$$$reportNull$$$0(0);
            }
            return new Thread(r, "Maven Artifact Downloader " + this.num.getAndIncrement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/idea/maven/project/MavenArtifactDownloader$1", "newThread"));
        }
    });
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final Collection<MavenProject> myMavenProjects;
    private final Collection<MavenArtifact> myArtifacts;
    private final MavenProgressIndicator myProgress;
    private final MavenEmbedderWrapper myEmbedder;

    public static DownloadResult download(@NotNull Project project, MavenProjectsTree projectsTree, Collection<MavenProject> mavenProjects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, MavenEmbedderWrapper embedder, MavenProgressIndicator p) throws MavenProcessCanceledException {
        if (project == null) {
            MavenArtifactDownloader.$$$reportNull$$$0(0);
        }
        return new MavenArtifactDownloader(project, projectsTree, mavenProjects, artifacts, embedder, p).download(downloadSources, downloadDocs);
    }

    private MavenArtifactDownloader(@NotNull Project project, MavenProjectsTree projectsTree, Collection<MavenProject> mavenProjects, Collection<MavenArtifact> artifacts, MavenEmbedderWrapper embedder, MavenProgressIndicator p) {
        if (project == null) {
            MavenArtifactDownloader.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myProjectsTree = projectsTree;
        this.myMavenProjects = mavenProjects;
        this.myArtifacts = artifacts == null ? null : new THashSet(artifacts);
        this.myEmbedder = embedder;
        this.myProgress = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadResult download(boolean downloadSources, boolean downloadDocs) throws MavenProcessCanceledException {
        DownloadResult downloadResult;
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        try {
            ArrayList<MavenExtraArtifactType> types = new ArrayList<MavenExtraArtifactType>(2);
            if (downloadSources) {
                types.add(MavenExtraArtifactType.SOURCES);
            }
            if (downloadDocs) {
                types.add(MavenExtraArtifactType.DOCS);
            }
            String caption = downloadSources && downloadDocs ? MavenProjectBundle.message("maven.downloading", new Object[0]) : (downloadSources ? MavenProjectBundle.message("maven.downloading.sources", new Object[0]) : MavenProjectBundle.message("maven.downloading.docs", new Object[0]));
            this.myProgress.setText(caption);
            Map<MavenId, DownloadData> artifacts = this.collectArtifactsToDownload(types);
            downloadResult = this.download(artifacts, downloadedFiles);
        }
        catch (Throwable throwable) {
            boolean isAsync = !ApplicationManager.getApplication().isUnitTestMode();
            HashSet<File> filesToRefresh = new HashSet<File>();
            for (File file : downloadedFiles) {
                filesToRefresh.add(file);
                filesToRefresh.add(file.getParentFile());
            }
            LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh, isAsync, false, null);
            throw throwable;
        }
        boolean isAsync = !ApplicationManager.getApplication().isUnitTestMode();
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (File file : downloadedFiles) {
            filesToRefresh.add(file);
            filesToRefresh.add(file.getParentFile());
        }
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh, isAsync, false, null);
        return downloadResult;
    }

    private Map<MavenId, DownloadData> collectArtifactsToDownload(List<MavenExtraArtifactType> types) {
        THashMap result = new THashMap();
        THashSet dependencyTypesFromSettings = new THashSet();
        if (!((Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myProject).getImportingSettings().getDependencyTypesAsSet());
            return true;
        })).booleanValue()) {
            return result;
        }
        for (MavenProject eachProject : this.myMavenProjects) {
            List<MavenRemoteRepository> repositories = eachProject.getRemoteRepositories();
            for (MavenArtifact eachDependency : eachProject.getDependencies()) {
                String dependencyType;
                if (this.myArtifacts != null && !this.myArtifacts.contains(eachDependency) || "system".equalsIgnoreCase(eachDependency.getScope()) || this.myProjectsTree.findProject(eachDependency.getMavenId()) != null || !dependencyTypesFromSettings.contains((Object)(dependencyType = eachDependency.getType())) && !eachProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
                MavenId id = eachDependency.getMavenId();
                DownloadData data = (DownloadData)result.get(id);
                if (data == null) {
                    data = new DownloadData();
                    result.put(id, data);
                }
                data.repositories.addAll(repositories);
                for (MavenExtraArtifactType eachType : types) {
                    Pair<String, String> classifierAndExtension = eachProject.getClassifierAndExtension(eachDependency, eachType);
                    String classifier = eachDependency.getFullClassifier((String)classifierAndExtension.first);
                    String extension = (String)classifierAndExtension.second;
                    data.classifiersWithExtensions.add(new DownloadElement(classifier, extension, eachType));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadResult download(Map<MavenId, DownloadData> toDownload, List<File> downloadedFiles) throws MavenProcessCanceledException {
        ArrayList futures = new ArrayList();
        AtomicInteger downloaded = new AtomicInteger();
        int total = 0;
        for (DownloadData each : toDownload.values()) {
            total += each.classifiersWithExtensions.size();
        }
        DownloadResult result = new DownloadResult();
        result.unresolvedSources.addAll(toDownload.keySet());
        result.unresolvedDocs.addAll(toDownload.keySet());
        try {
            for (Map.Entry<MavenId, DownloadData> entry : toDownload.entrySet()) {
                this.myProgress.checkCanceled();
                DownloadData data = entry.getValue();
                MavenId id = entry.getKey();
                for (DownloadElement eachElement : data.classifiersWithExtensions) {
                    int finalTotal = total;
                    futures.add(EXECUTOR.submit(() -> {
                        block10: {
                            try {
                                if (this.myProject.isDisposed()) {
                                    return;
                                }
                                this.myProgress.checkCanceled();
                                this.myProgress.setFraction((double)downloaded.getAndIncrement() / (double)finalTotal);
                                MavenArtifact a = this.myEmbedder.resolve(new MavenArtifactInfo(id, eachElement.extension, eachElement.classifier), new ArrayList<MavenRemoteRepository>(data.repositories));
                                File file = a.getFile();
                                if (!file.exists()) break block10;
                                List list = downloadedFiles;
                                synchronized (list) {
                                    downloadedFiles.add(file);
                                    switch (eachElement.type) {
                                        case SOURCES: {
                                            result.resolvedSources.add(id);
                                            result.unresolvedSources.remove(id);
                                            break;
                                        }
                                        case DOCS: {
                                            result.resolvedDocs.add(id);
                                            result.unresolvedDocs.remove(id);
                                        }
                                    }
                                }
                            }
                            catch (MavenProcessCanceledException mavenProcessCanceledException) {
                                // empty catch block
                            }
                        }
                    }));
                }
            }
        }
        finally {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void awaitQuiescence(long timeout, @NotNull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            MavenArtifactDownloader.$$$reportNull$$$0(2);
        }
        ConcurrencyUtil.awaitQuiescence((ThreadPoolExecutor)EXECUTOR, (long)timeout, (TimeUnit)unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenArtifactDownloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "download";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "awaitQuiescence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DownloadResult {
        public final Set<MavenId> resolvedSources = new THashSet();
        public final Set<MavenId> resolvedDocs = new THashSet();
        public final Set<MavenId> unresolvedSources = new THashSet();
        public final Set<MavenId> unresolvedDocs = new THashSet();
    }

    private static class DownloadElement {
        public final String classifier;
        public final String extension;
        public final MavenExtraArtifactType type;

        DownloadElement(String classifier, String extension, MavenExtraArtifactType type) {
            this.classifier = classifier;
            this.extension = extension;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DownloadElement that = (DownloadElement)o;
            if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
                return false;
            }
            if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.classifier != null ? this.classifier.hashCode() : 0;
            result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    private static class DownloadData {
        public final LinkedHashSet<MavenRemoteRepository> repositories = new LinkedHashSet();
        public final LinkedHashSet<DownloadElement> classifiersWithExtensions = new LinkedHashSet();

        private DownloadData() {
        }
    }
}

