/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenModelInspection
extends BasicDomElementsInspection<MavenDomProjectModel> {
    public MavenModelInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenModelInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenModelInspection";
    }

    private static boolean isElementInsideManagedFile(GenericDomValue value) {
        VirtualFile virtualFile = DomUtil.getFile((DomElement)value).getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(value.getManager().getProject());
        return projectsManager.findProject(virtualFile) != null;
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        if (!MavenModelInspection.isElementInsideManagedFile(value)) {
            return false;
        }
        Converter converter = value.getConverter();
        if (converter instanceof MavenDomSoftAwareConverter) {
            return !((MavenDomSoftAwareConverter)converter).isSoft((DomElement)value);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenModelInspection", "getGroupDisplayName"));
    }
}

