/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import git4idea.update.GitUpdateExecutionProcess;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable GitRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup popupGroup = new LightActionGroup(false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository)) {
            popupGroup.addAll(GitBranchPopupActions.getRebaseActions());
        } else {
            popupGroup.addAll(GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.local.branches", new Object[0]) : GitBundle.message("branches.local.branches.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).sorted((b1, b2) -> {
            int delta = BranchActionUtil.FAVORITE_BRANCH_COMPARATOR.compare(b1, b2);
            if (delta != 0) {
                return delta;
            }
            return StringUtil.naturalCompare((String)b1.myBranchName, (String)b2.myBranchName);
        })).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions.add(0, new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.remote.branches", new Object[0]) : GitBundle.message("branches.remote.branches.in.repo", specificRepository));
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, (List<? extends GitRepository>)repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec;
        if (spec == null) {
            GitBranchPopupActions.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(1);
        }
        return (repositoriesFromSpec = spec.getAllRepositories()).size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.mapNotNull(GitBranchPopupActions.getRebaseActions(), action -> GitBranchPopupActions.createRepositoryRebaseAction(action, repository));
        if (list2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Git.Ongoing.Rebase.Actions");
        List<AnAction> list2 = Arrays.asList(group.getChildren(null));
        if (list2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    private static AnAction createRepositoryRebaseAction(@NotNull AnAction rebaseAction, final @NotNull GitRepository repository) {
        if (rebaseAction == null) {
            GitBranchPopupActions.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(6);
        }
        if (!(rebaseAction instanceof GitOngoingOperationAction)) {
            return null;
        }
        final GitOngoingOperationAction ongoingAction = (GitOngoingOperationAction)rebaseAction;
        DumbAwareAction repositoryAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabledAndVisible(ongoingAction.isEnabled(repository));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                ongoingAction.performInBackground(repository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        return repositoryAction;
    }

    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Collection<? extends GitRepository> repositories) {
        Set currentBranches;
        if (repositories == null) {
            GitBranchPopupActions.$$$reportNull$$$0(7);
        }
        if ((currentBranches = ContainerUtil.map2Set(repositories, repo -> (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)Objects.requireNonNull(repo.getCurrentRevision()))))).size() == 1) {
            return GitBranchPopupActions.getBranchPresentation((String)currentBranches.iterator().next());
        }
        String string = GitBundle.message("branches.current.branch", new Object[0]);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getBranchPresentation(@NotNull String branch) {
        if (branch == null) {
            GitBranchPopupActions.$$$reportNull$$$0(9);
        }
        String string = "'" + branch + "'";
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPerRepoRebaseActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebaseActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSpecForRepo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPerRepoRebaseActions";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRepositoryRebaseAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchPresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBranchPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myTagName;

        TagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String tagName) {
            if (project == null) {
                TagActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                TagActions.$$$reportNull$$$0(1);
            }
            if (tagName == null) {
                TagActions.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
            if (anActionArray == null) {
                TagActions.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<? extends GitRepository> repositories, String tagName) {
                super(IdeBundle.messagePointer((String)"button.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteTagAction.$$$reportNull$$$0(0);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$TagActions$DeleteTagAction", "actionPerformed"));
            }
        }
    }

    private static class UpdateSelectedBranchAction
    extends DumbAwareAction
    implements CustomIconProvider {
        protected final Project myProject;
        protected final List<? extends GitRepository> myRepositories;
        protected final String myBranchName;
        protected final List<String> myBranchNameList;
        protected final boolean myHasIncoming;

        UpdateSelectedBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean hasIncoming) {
            if (project == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.update", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myBranchNameList = Collections.singletonList(branchName);
            this.myHasIncoming = hasIncoming;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(3);
            }
            Presentation presentation = e.getPresentation();
            if (!GitBranchActionsUtilKt.hasRemotes(this.myProject)) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            String branchPresentation = GitBranchPopupActions.getBranchPresentation(this.myBranchName);
            String description = GitBundle.message("action.Git.Update.Selected.description", this.myBranchNameList.size(), GitVcsSettings.getInstance(this.myProject).getUpdateMethod().getName().toLowerCase(Locale.ROOT));
            presentation.setDescription(description);
            if (GitFetchSupport.fetchSupport(this.myProject).isFetchRunning()) {
                presentation.setEnabled(false);
                presentation.setDescription(GitBundle.message("branches.update.is.already.running", new Object[0]));
                return;
            }
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(this.myBranchNameList, this.myRepositories);
            presentation.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation.setDescription(GitBundle.message("branches.tracking.branch.doesn.t.configured.for.s", branchPresentation));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(4);
            }
            GitBranchActionsUtilKt.updateBranches(this.myProject, this.myRepositories, this.myBranchNameList);
        }

        @Nullable
        public Icon getRightIcon() {
            return this.myHasIncoming ? DvcsImplIcons.Incoming : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$UpdateSelectedBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(3);
            }
            String description = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), this.myBranchName);
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(4);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        RebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                RebaseAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                RebaseAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RebaseAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.rebase.current.onto.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isOnBranch;
            if (e == null) {
                RebaseAction.$$$reportNull$$$0(3);
            }
            String description = (isOnBranch = ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch)) ? GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), GitBranchPopupActions.getBranchPresentation(this.myBranchName)) : GitBundle.message("branches.rebase.is.not.possible.in.the.detached.head.state", new Object[0]);
            e.getPresentation().setDescription(description);
            e.getPresentation().setEnabled(isOnBranch);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RebaseAction.$$$reportNull$$$0(4);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RebaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        MergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            if (project == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.merge.into.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(3);
            }
            String description = GitBundle.message("branches.merge.into", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(4);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowDiffWithBranchAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        ShowDiffWithBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.show.diff.with.working.tree", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(3);
            }
            GitBrancher.getInstance(this.myProject).showDiffWithLocal(this.myBranchName, this.myRepositories);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabledAndVisible(!new GitMultiRootBranchConfig(this.myRepositories).diverged());
            String description = GitBundle.message("branches.compare.the.current.working.tree.with", GitBranchPopupActions.getBranchPresentation(this.myBranchName));
            e.getPresentation().setDescription(description);
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.show.diff", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$ShowDiffWithBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CompareAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CompareAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CompareAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CompareAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.compare.with.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompareAction.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompareAction.$$$reportNull$$$0(4);
            }
            String description = GitBundle.message("branches.show.commits.in", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CompareAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CheckoutAsNewBranch
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CheckoutAsNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.new.branch.from.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(3);
            }
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(4);
            }
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, this.myBranchName + "^0", GitBundle.message("action.Git.New.Branch.dialog.title", this.myBranchName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutAsNewBranch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        @NlsSafe
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                RemoteBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                RemoteBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RemoteBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                RemoteBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new PullWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new PullWithMergeAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                RemoteBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(2);
                }
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(3);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(4);
                }
                e.getPresentation().setEnabled(!GitProtectedBranchesKt.isRemoteBranchProtected(this.myRepositories, this.myBranchName));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PullWithRebaseAction
        extends PullBranchBaseAction {
            PullWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(2);
                }
                super(project, repositories, branchName, UpdateMethod.REBASE);
                this.getTemplatePresentation().setText(GitBundle.messagePointer("branches.action.pull.rebase", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullWithRebaseAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PullWithMergeAction
        extends PullBranchBaseAction {
            PullWithMergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    PullWithMergeAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    PullWithMergeAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PullWithMergeAction.$$$reportNull$$$0(2);
                }
                super(project, repositories, branchName, UpdateMethod.MERGE);
                this.getTemplatePresentation().setText(GitBundle.messagePointer("branches.action.pull.merge", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullWithMergeAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PullBranchBaseAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;
            private final UpdateMethod myUpdateMethod;

            PullBranchBaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName, UpdateMethod updateMethod) {
                if (project == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(2);
                }
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
                this.myUpdateMethod = updateMethod;
            }

            private static Map<GitRepository, GitBranchPair> configureTarget(List<? extends GitRepository> repositories, String branchName) {
                LinkedHashMap map2 = new LinkedHashMap();
                for (GitRepository gitRepository : repositories) {
                    GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
                    GitRemoteBranch remoteBranch = gitRepository.getBranches().findRemoteBranch(branchName);
                    if (currentBranch == null || remoteBranch == null) continue;
                    map2.put(gitRepository, new GitBranchPair(currentBranch, remoteBranch));
                }
                return map2;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(3);
                }
                new GitUpdateExecutionProcess(this.myProject, this.myRepositories, PullBranchBaseAction.configureTarget(this.myRepositories, this.myRemoteBranchName), this.myUpdateMethod, false).execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteBranchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullBranchBaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;

            CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(2);
                }
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public static void checkoutRemoteBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                boolean hasCommits;
                GitRepository repository;
                GitRemoteBranch remoteBranch;
                String suggestedLocalName;
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(3);
                }
                if (repositories == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(4);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(5);
                }
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)(suggestedLocalName = (remoteBranch = Objects.requireNonNull((repository = repositories.get(0)).getBranches().findRemoteBranch(remoteBranchName))).getNameForRemoteOperations()))) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                Map conflictingLocalBranches = ContainerUtil.map2MapNotNull(repositories, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(suggestedLocalName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (CheckoutRemoteBranchAction.hasTrackingConflicts(conflictingLocalBranches, remoteBranchName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                boolean bl = hasCommits = !conflictingLocalBranches.isEmpty() && GitBranchActionsUtilKt.checkCommitsUnderProgress(project, repositories, remoteBranchName, suggestedLocalName);
                if (hasCommits) {
                    int result2 = Messages.showYesNoCancelDialog((String)GitBundle.message("local.branch.already.exists.and.has.commits.which.do.not.exist.in.remote", suggestedLocalName, remoteBranchName), (String)GitBundle.message("checkout.0", remoteBranchName), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                    if (result2 == 2) {
                        return;
                    }
                    if (result2 == 0) {
                        GitBranchActionsUtilKt.checkout(project, repositories, remoteBranchName, suggestedLocalName, true);
                        return;
                    }
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(suggestedLocalName, remoteBranchName, !conflictingLocalBranches.isEmpty(), repositories, null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(6);
                }
                CheckoutRemoteBranchAction.checkoutRemoteBranch(this.myProject, this.myRepositories, this.myRemoteBranchName);
            }

            private static void askNewBranchNameAndCheckout(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName, @NotNull String suggestedLocalName) {
                GitNewBranchOptions options;
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(7);
                }
                if (repositories == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(8);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(9);
                }
                if (suggestedLocalName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(10);
                }
                if ((options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.checkout.s", remoteBranchName), suggestedLocalName, false, true).showAndGetOptions()) == null) {
                    return;
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(options.getName(), remoteBranchName, options.shouldReset(), repositories, null);
            }

            private static boolean hasTrackingConflicts(@NotNull Map<GitRepository, GitLocalBranch> conflictingLocalBranches, @NotNull String remoteBranchName) {
                if (conflictingLocalBranches == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(11);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(12);
                }
                return ContainerUtil.or(conflictingLocalBranches.keySet(), r -> {
                    GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(r, (GitLocalBranch)conflictingLocalBranches.get(r));
                    return trackInfo != null && !GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)trackInfo.getRemoteBranch().getName());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteBranchName";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suggestedLocalName";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conflictingLocalBranches";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkoutRemoteBranch";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "askNewBranchNameAndCheckout";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasTrackingConflicts";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class CurrentBranchActions
    extends LocalBranchActions {
        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                CurrentBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                CurrentBranchActions.$$$reportNull$$$0(3);
            }
            super(project, repositories, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new LocalBranchActions.PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                CurrentBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        @NlsSafe
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                LocalBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                LocalBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                LocalBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                LocalBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = ContainerUtil.immutableList(repositories);
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.getTemplatePresentation().putClientProperty("ToolTipText", (Object)this.constructTooltip());
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        List<GitRepository> getRepositories() {
            List<GitRepository> list2 = this.myRepositories;
            if (list2 == null) {
                LocalBranchActions.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public String getBranchName() {
            String string = this.myBranchName;
            if (string == null) {
                LocalBranchActions.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        private String constructTooltip() {
            boolean incoming = this.hasIncomingCommits();
            boolean outgoing = this.hasOutgoingCommits();
            if (!incoming && !outgoing) {
                return null;
            }
            if (incoming && outgoing) {
                return GitBundle.message("branches.there.are.incoming.and.outgoing.commits", new Object[0]);
            }
            if (incoming) {
                return GitBundle.message("branches.there.are.incoming.commits", new Object[0]);
            }
            return GitBundle.message("branches.there.are.outgoing.commits", new Object[0]);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                LocalBranchActions.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepositories";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<? extends GitRepository> repositories, String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteAction.$$$reportNull$$$0(0);
                }
                GitBrancher.getInstance(this.myProject).deleteBranch(this.myBranchName, ContainerUtil.filter(this.myRepositories, repository -> !this.myBranchName.equals(repository.getCurrentBranchName())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$DeleteAction", "actionPerformed"));
            }
        }

        public static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<? extends GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            RenameBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                if (project == null) {
                    RenameBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    RenameBranchAction.$$$reportNull$$$0(1);
                }
                if (currentBranchName == null) {
                    RenameBranchAction.$$$reportNull$$$0(2);
                }
                super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(3);
                }
                RenameBranchAction.rename(this.myProject, this.myRepositories, this.myCurrentBranchName);
            }

            public static void rename(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                GitNewBranchOptions options;
                if (project == null) {
                    RenameBranchAction.$$$reportNull$$$0(4);
                }
                if (repositories == null) {
                    RenameBranchAction.$$$reportNull$$$0(5);
                }
                if (currentBranchName == null) {
                    RenameBranchAction.$$$reportNull$$$0(6);
                }
                if ((options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.rename.branch", currentBranchName), currentBranchName, false, false, false, false, GitBranchOperationType.RENAME).showAndGetOptions()) != null) {
                    GitBrancher brancher = GitBrancher.getInstance(project);
                    brancher.renameBranch(currentBranchName, options.getName(), repositories);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(7);
                }
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.rename.branch", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentBranchName";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rename";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PushBranchAction
        extends DumbAwareAction
        implements CustomIconProvider {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;
            private final boolean myHasCommitsToPush;

            PushBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean hasCommitsToPush) {
                if (project == null) {
                    PushBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    PushBranchAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PushBranchAction.$$$reportNull$$$0(2);
                }
                super(ActionsBundle.messagePointer((String)"action.Vcs.Push.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
                this.myHasCommitsToPush = hasCommitsToPush;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    PushBranchAction.$$$reportNull$$$0(3);
                }
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.push", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    PushBranchAction.$$$reportNull$$$0(4);
                }
                GitLocalBranch localBranch = this.myRepositories.get(0).getBranches().findLocalBranch(this.myBranchName);
                assert (localBranch != null);
                new VcsPushDialog(this.myProject, this.myRepositories, this.myRepositories, null, (PushSource)GitPushSource.create(localBranch)).show();
            }

            @Nullable
            public Icon getRightIcon() {
                return this.myHasCommitsToPush ? DvcsImplIcons.Outgoing : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$PushBranchAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            public CheckoutAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutAction.$$$reportNull$$$0(2);
                }
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutAction.$$$reportNull$$$0(3);
                }
                CheckoutAction.checkoutBranch(this.myProject, this.myRepositories, this.myBranchName);
            }

            public static void checkoutBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAction.$$$reportNull$$$0(4);
                }
                if (repositories == null) {
                    CheckoutAction.$$$reportNull$$$0(5);
                }
                if (branchName == null) {
                    CheckoutAction.$$$reportNull$$$0(6);
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkout(branchName, false, repositories, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkoutBranch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super(GitBundle.messagePointer("branches.checkout.tag.or.revision", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitRefDialog dialog2;
            if (e == null) {
                CheckoutRevisionActions.$$$reportNull$$$0(0);
            }
            if ((dialog2 = new GitRefDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout", new Object[0]), GitBundle.message("branches.enter.reference.branch.tag.name.or.commit.hash", new Object[0]))).showAndGet()) {
                String reference = dialog2.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutRevisionActions.$$$reportNull$$$0(1);
            }
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.checkout", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutRevisionActions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            if (project == null) {
                GitNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                GitNewBranchAction.$$$reportNull$$$0(1);
            }
            super(project, repositories);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GitNewBranchAction.$$$reportNull$$$0(2);
            }
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, "HEAD");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

