/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "settings", "Lcom/intellij/debugger/settings/ThreadsViewSettings;", "render", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "location", "Lcom/sun/jdi/Location;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "renderCreationNode", "renderErrorNode", "error", "", "renderGroup", "groupName", "renderInfoNode", "text", "kotlin.jvm-debugger.coroutines"})
public final class SimpleColoredTextIconPresentationRenderer {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty log$delegate = ProvidersKt.getLogger();
    private final ThreadsViewSettings settings;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(SimpleColoredTextIconPresentationRenderer.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final SimpleColoredTextIcon render(@NotNull CoroutineInfoData infoData) {
        Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
        thread = infoData.getActiveThread();
        v0 = thread;
        if (v0 == null || (v0 = v0.name()) == null || (v0 = StringsKt.substringBefore$default((String)v0, (String)(" @" + infoData.getKey().getName()), null, (int)2, null)) == null) {
            v0 = "";
        }
        name = v0;
        threadState = thread != null ? DebuggerUtilsEx.getThreadStatusText((int)thread.status()) : "";
        icon = SimpleColoredTextIconKt.fromState(infoData.getKey().getState());
        var7_6 = infoData.getStackTrace();
        var8_7 = false;
        if (var7_6.isEmpty() == false) ** GOTO lbl-1000
        var7_6 = infoData.getCreationStackTrace();
        var8_7 = false;
        if (var7_6.isEmpty() == false) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        hasChildren = v1;
        label = new SimpleColoredTextIcon(icon, hasChildren);
        label.append$kotlin_jvm_debugger_coroutines("\"");
        label.appendValue$kotlin_jvm_debugger_coroutines(infoData.getKey().formatName());
        label.append$kotlin_jvm_debugger_coroutines("\": " + (Object)infoData.getKey().getState());
        var8_8 = (CharSequence)name;
        var9_10 = false;
        if (var8_8.length() > 0) {
            label.append$kotlin_jvm_debugger_coroutines(" on thread \"");
            label.appendValue$kotlin_jvm_debugger_coroutines((String)name);
            label.append$kotlin_jvm_debugger_coroutines("\": " + threadState);
        }
        return label;
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        SimpleColoredTextIcon label = new SimpleColoredTextIcon(null, false);
        DebuggerUIUtil.getColorScheme(null);
        if (location2.method() != null) {
            String methodDisplay;
            String myName = location2.method().name();
            String string = methodDisplay = this.settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments((Method)location2.method()) : myName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodDisplay");
            label.appendValue$kotlin_jvm_debugger_coroutines(string);
        }
        if (this.settings.SHOW_LINE_NUMBER) {
            label.append$kotlin_jvm_debugger_coroutines(":");
            label.append$kotlin_jvm_debugger_coroutines("" + DebuggerUtilsEx.getLineNumber((Location)location2, (boolean)false));
        }
        if (this.settings.SHOW_CLASS_NAME) {
            Object refType;
            String name = null;
            try {
                ReferenceType referenceType = location2.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
                refType = referenceType;
                refType = refType.name();
            }
            catch (InternalError e) {
                refType = e.toString();
            }
            name = refType;
            if (name != null) {
                label.append$kotlin_jvm_debugger_coroutines(", ");
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex < 0) {
                    label.append$kotlin_jvm_debugger_coroutines(name);
                } else {
                    String string = name;
                    int n = dotIndex + 1;
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    label.append$kotlin_jvm_debugger_coroutines(string2);
                    if (this.settings.SHOW_PACKAGE_NAME) {
                        StringBuilder stringBuilder = new StringBuilder().append(" (");
                        string = name;
                        n = 0;
                        bl = false;
                        String string3 = string.substring(n, dotIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        label.append$kotlin_jvm_debugger_coroutines(stringBuilder.append(string3).append(')').toString());
                    }
                }
            }
        }
        if (this.settings.SHOW_SOURCE_NAME) {
            String sourceName2;
            label.append$kotlin_jvm_debugger_coroutines(", ");
            String string = sourceName2 = DebuggerUtilsEx.getSourceName((Location)location2, (Function)new Function<Throwable, String>(this, location2){
                final /* synthetic */ SimpleColoredTextIconPresentationRenderer this$0;
                final /* synthetic */ Location $location;

                public final String apply(@Nullable Throwable e) {
                    this.this$0.getLog().error("Error while trying to resolve sourceName for location", e, new String[]{this.$location.toString()});
                    return "Unknown Source";
                }
                {
                    this.this$0 = simpleColoredTextIconPresentationRenderer;
                    this.$location = location2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceName");
            label.append$kotlin_jvm_debugger_coroutines(string);
        }
        return label;
    }

    @NotNull
    public final SimpleColoredTextIcon renderCreationNode(@NotNull CoroutineInfoData infoData) {
        Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
        return new SimpleColoredTextIcon(AllIcons.Debugger.ThreadSuspended, true, KotlinDebuggerCoroutinesBundle.message("coroutine.dump.creation.trace", new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderErrorNode(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return new SimpleColoredTextIcon(AllIcons.Actions.Lightning, false, KotlinDebuggerCoroutinesBundle.message(error, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderInfoNode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new SimpleColoredTextIcon(AllIcons.General.Information, false, KotlinDebuggerCoroutinesBundle.message(text, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(AllIcons.Debugger.ThreadGroup, true, groupName);
    }

    public SimpleColoredTextIconPresentationRenderer() {
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)threadsViewSettings, (String)"ThreadsViewSettings.getInstance()");
        this.settings = threadsViewSettings;
    }
}

