/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.io.DigestUtil;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0007J\b\u0010 \u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\u0016\u0010\"\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0004J\f\u0010#\u001a\u00020\r*\u00020\u0004H\u0002J\f\u0010$\u001a\u00020\u0004*\u00020%H\u0002J\f\u0010&\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "IDEA_HEADLESS_STATISTICS_DEVICE_ID", "", "IDEA_HEADLESS_STATISTICS_SALT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SALT_PREFERENCE_KEY", "anonymizedCache", "Ljava/util/HashMap;", "bucket", "", "getBucket", "()I", "build", "getBuild", "()Ljava/lang/String;", "build$delegate", "Lkotlin/Lazy;", "deviceId", "getDeviceId", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "getEventLogDataPath", "Ljava/nio/file/Path;", "getEventLogSettingsPath", "getOrGenerateDeviceId", "getOrGenerateSalt", "hashSha256", "asBucket", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogConfiguration {
    private static final Logger LOG;
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    private static final String IDEA_HEADLESS_STATISTICS_DEVICE_ID = "idea.headless.statistics.device.id";
    private static final String IDEA_HEADLESS_STATISTICS_SALT = "idea.headless.statistics.salt";
    @NotNull
    private static final String sessionId;
    @NotNull
    private static final String deviceId;
    private static final int bucket;
    @NotNull
    private static final Lazy build$delegate;
    private static final byte[] salt;
    private static final HashMap<String, String> anonymizedCache;
    public static final EventLogConfiguration INSTANCE;

    @NotNull
    public final String getSessionId() {
        return sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return deviceId;
    }

    public final int getBucket() {
        return bucket;
    }

    @NotNull
    public final String getBuild() {
        Lazy lazy = build$delegate;
        EventLogConfiguration eventLogConfiguration = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        if (anonymizedCache.containsKey(data)) {
            String string = anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        String result = this.hashSha256(salt, data);
        ((Map)anonymizedCache).put(data, result);
        return result;
    }

    @NotNull
    public final String hashSha256(@NotNull byte[] salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MessageDigest md = DigestUtil.sha256();
        md.update(salt);
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        String string2 = StringUtil.toHexString((byte[])md.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toHexString(md.digest())");
        return string2;
    }

    private final String shortedUUID(String $this$shortedUUID) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.asStringWithoutProductCodeAndSnapshot()");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getOrGenerateDeviceId() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String string = System.getProperty(IDEA_HEADLESS_STATISTICS_DEVICE_ID);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        String string = DeviceIdManager.getOrGenerateId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DeviceIdManager.getOrGenerateId()");
        return string;
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String string2 = System.getProperty(IDEA_HEADLESS_STATISTICS_SALT);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = it;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return byArray;
            }
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string6 = companyName;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"companyName");
            String string7 = string6;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale it = locale;
            boolean bl = false;
            String string8 = string7;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.toLowerCase(it);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        byte[] salt = prefs.getByteArray(SALT_PREFERENCE_KEY, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(SALT_PREFERENCE_KEY, salt);
            LOG.info("Generating salt for the device");
        }
        return salt;
    }

    @NotNull
    public final Path getEventLogDataPath() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log-data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026resolve(\"event-log-data\")");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getEventLogSettingsPath() {
        Path path = INSTANCE.getEventLogDataPath().resolve("settings");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getEventLogDataPath().resolve(\"settings\")");
        return path;
    }

    private EventLogConfiguration() {
    }

    static {
        EventLogConfiguration eventLogConfiguration;
        INSTANCE = eventLogConfiguration = new EventLogConfiguration();
        Logger logger2 = Logger.getInstance(EventLogConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Event\u2026onfiguration::class.java)");
        LOG = logger2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        sessionId = eventLogConfiguration.shortedUUID(string);
        deviceId = eventLogConfiguration.getOrGenerateDeviceId();
        bucket = eventLogConfiguration.asBucket(deviceId);
        build$delegate = LazyKt.lazy((Function0)build.2.INSTANCE);
        salt = eventLogConfiguration.getOrGenerateSalt();
        anonymizedCache = new HashMap();
    }

    public static final /* synthetic */ String access$asBuildNumber(EventLogConfiguration $this, BuildNumber $this$access_u24asBuildNumber) {
        return $this.asBuildNumber($this$access_u24asBuildNumber);
    }
}

