/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Closeables {
    private static Logger logger = Logger.getLogger(Closeables.class.getCanonicalName());

    private Closeables() {
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable c : closeables) {
            Closeables.close(c);
        }
    }

    private static void close(@Nullable Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Error occurred while closing " + c, t);
        }
    }
}

