/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalTraceInterpreter
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (call2 == null) {
            OptionalTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            OptionalTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            Value peeksResult = ((ArrayReference)value).getValue(0);
            TraceInfo peekInfo = this.myPeekResolver.resolve(call2, peeksResult);
            Map<Integer, TraceElement> before = peekInfo.getValuesOrderBefore();
            Value optionalTrace = ((ArrayReference)value).getValue(1);
            Value optionalValue = OptionalTraceInterpreter.getOptionalValue(optionalTrace);
            if (optionalValue == null) {
                return new ValuesOrderInfo(call2, before, Collections.emptyMap());
            }
            TraceElementImpl element = new TraceElementImpl(0x7FFFFFFE, optionalValue);
            return new ValuesOrderInfo(call2, before, Collections.singletonMap(element.getTime(), element));
        }
        throw new UnexpectedValueException("trace termination with optional result must be an array value");
    }

    @Nullable
    private static Value getOptionalValue(@NotNull Value optionalTrace) {
        if (optionalTrace == null) {
            OptionalTraceInterpreter.$$$reportNull$$$0(2);
        }
        if (!(optionalTrace instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("optional trace must be an array value");
        }
        ArrayReference trace = (ArrayReference)optionalTrace;
        if (!OptionalTraceInterpreter.optionalIsPresent(trace)) {
            return null;
        }
        Value value = trace.getValue(1);
        if (value instanceof ArrayReference) {
            return ((ArrayReference)value).getValue(0);
        }
        throw new UnexpectedValueTypeException("unexpected format for an optional value");
    }

    private static boolean optionalIsPresent(@NotNull ArrayReference optionalTrace) {
        Value isPresentValue;
        Value isPresentFlag;
        if (optionalTrace == null) {
            OptionalTraceInterpreter.$$$reportNull$$$0(3);
        }
        if ((isPresentFlag = optionalTrace.getValue(0)) instanceof ArrayReference && (isPresentValue = ((ArrayReference)isPresentFlag).getValue(0)) instanceof BooleanValue) {
            return ((BooleanValue)isPresentValue).value();
        }
        throw new UnexpectedValueTypeException("unexpected format for optional isPresent value");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalTrace";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/streams/trace/impl/interpret/OptionalTraceInterpreter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionalValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "optionalIsPresent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

