/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.tooling.model.build.GradleEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.IncompatibleGradleJdkIssueChecker;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
public final class IncompatibleGradleJdkIssueChecker
implements GradleIssueChecker {
    private static final String couldNotDetermineJavaPrefix = "org.gradle.api.GradleException: Could not determine Java version using executable ";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        GradleVersion gradleVersion;
        boolean bl;
        JavaVersion javaVersion;
        List quickFixes;
        boolean unableToStartDaemonProcessForJDK11;
        boolean unableToStartDaemonProcessForJDK9;
        boolean isRemovedUnsafeDefineClassMethodInJDK11Issue;
        JavaVersion javaVersionUsed;
        boolean isUnsupportedJavaRuntimeIssue;
        boolean couldNotDetermineJavaIssue;
        GradleVersion gradleVersionUsed;
        Throwable rootCause;
        block23: {
            block22: {
                Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
                rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
                String rootCauseText = rootCause.toString();
                gradleVersionUsed = null;
                if (issueData.getBuildEnvironment() != null) {
                    GradleEnvironment gradleEnvironment = issueData.getBuildEnvironment().getGradle();
                    Intrinsics.checkNotNullExpressionValue((Object)gradleEnvironment, (String)"issueData.buildEnvironment.gradle");
                    gradleVersionUsed = GradleVersion.version((String)gradleEnvironment.getGradleVersion());
                }
                couldNotDetermineJavaIssue = IncompatibleGradleJdkIssueChecker.Companion.couldNotDetermineJavaIssue(rootCauseText);
                isUnsupportedJavaRuntimeIssue = Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedJavaRuntimeException.class.getSimpleName()) || couldNotDetermineJavaIssue;
                javaVersionUsed = IncompatibleGradleJdkIssueChecker.Companion.detectJavaVersion(couldNotDetermineJavaIssue, rootCauseText, issueData);
                Throwable throwable = rootCause;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"rootCause");
                isRemovedUnsafeDefineClassMethodInJDK11Issue = IncompatibleGradleJdkIssueChecker.Companion.causedByUnsafeDefineClassApiUsage(gradleVersionUsed, javaVersionUsed, throwable, rootCauseText);
                unableToStartDaemonProcessForJDK9 = false;
                unableToStartDaemonProcessForJDK11 = false;
                if (!isRemovedUnsafeDefineClassMethodInJDK11Issue && StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)rootCauseText, (CharSequence)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null) && gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo(GradleVersion.version((String)"4.6")) <= 0) {
                    if (gradleVersionUsed.getBaseVersion().compareTo(GradleVersion.version((String)"3.0")) < 0) {
                        unableToStartDaemonProcessForJDK9 = true;
                    } else {
                        unableToStartDaemonProcessForJDK11 = true;
                    }
                }
                if (!(isUnsupportedJavaRuntimeIssue || isRemovedUnsafeDefineClassMethodInJDK11Issue || unableToStartDaemonProcessForJDK11 || unableToStartDaemonProcessForJDK9 || !(Intrinsics.areEqual((Object)rootCauseText, (Object)"java.lang.RuntimeException: Could not determine Java version.") ^ true))) {
                    return null;
                }
                boolean bl2 = false;
                quickFixes = new ArrayList();
                javaVersion = javaVersionUsed;
                if (javaVersion == null) break block22;
                JavaVersion javaVersion2 = javaVersion;
                boolean bl3 = false;
                bl = false;
                JavaVersion it = javaVersion2;
                boolean bl4 = false;
                javaVersion = GradleJvmResolutionUtil.suggestOldestCompatibleGradleVersion(it);
                if (javaVersion != null) break block23;
            }
            javaVersion = GradleVersion.version((String)"4.8.1");
        }
        JavaVersion oldestCompatibleGradleVersion = javaVersion;
        JavaVersion javaVersion3 = javaVersionUsed;
        if (javaVersion3 != null) {
            JavaVersion javaVersion4 = javaVersion3;
            bl = false;
            boolean it = false;
            JavaVersion it2 = javaVersion4;
            boolean bl5 = false;
            gradleVersion = GradleJvmResolutionUtil.suggestGradleVersion(it2);
        } else {
            gradleVersion = null;
        }
        GradleVersion newestCompatibleGradleVersion = gradleVersion;
        JavaVersion javaVersion5 = oldestCompatibleGradleVersion;
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion5, (String)"oldestCompatibleGradleVersion");
        String versionSuggestion = IncompatibleGradleJdkIssueChecker.Companion.getSuggestedGradleVersion(newestCompatibleGradleVersion, (GradleVersion)javaVersion5);
        StringBuilder issueDescription = new StringBuilder();
        if (couldNotDetermineJavaIssue || isRemovedUnsafeDefineClassMethodInJDK11Issue && newestCompatibleGradleVersion != null) {
            issueDescription.append("Unsupported Java. \n").append("Your build is currently configured to use Java " + javaVersionUsed + ". It's recommended to use Gradle " + versionSuggestion + '.');
        } else {
            issueDescription.append(rootCause.getMessage());
        }
        String gradleVersionString = gradleVersionUsed != null ? gradleVersionUsed.getVersion() : "version";
        if (isRemovedUnsafeDefineClassMethodInJDK11Issue) {
            issueDescription.append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 11 or newer.\n" + "See details at https://github.com/gradle/gradle/issues/4860\n");
        } else if (unableToStartDaemonProcessForJDK9) {
            StringsKt.clear((StringBuilder)issueDescription).append("Unable to start the daemon process.").append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 9 or newer.\n");
        } else if (unableToStartDaemonProcessForJDK11) {
            StringsKt.clear((StringBuilder)issueDescription).append("Unable to start the daemon process.").append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 11 or newer.\n");
        } else if (isUnsupportedJavaRuntimeIssue) {
            issueDescription.append("\n");
        }
        issueDescription.append("\nPossible solution:\n");
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(issueData.getProjectPath());
        if (wrapperPropertiesFile == null || gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo((GradleVersion)oldestCompatibleGradleVersion) < 0) {
            GradleVersionQuickFix gradleVersionFix = new GradleVersionQuickFix(issueData.getProjectPath(), (GradleVersion)oldestCompatibleGradleVersion, true);
            issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + oldestCompatibleGradleVersion.getVersion() + " version " + "and re-import the project</a>\n");
            quickFixes.add(gradleVersionFix);
        } else {
            GradleWrapperSettingsOpenQuickFix wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), "distributionUrl");
            String string = issueData.getProjectPath();
            ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
            ReimportQuickFix reimportQuickFix = new ReimportQuickFix(string, projectSystemId);
            issueDescription.append(" - <a href=\"" + wrapperSettingsOpenQuickFix.getId() + "\">Open Gradle wrapper settings</a>, " + "change `distributionUrl` property to use compatible Gradle version and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
            quickFixes.add(wrapperSettingsOpenQuickFix);
            quickFixes.add(reimportQuickFix);
        }
        if (Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix()) ^ true) {
            GradleSettingsQuickFix gradleSettingsFix2 = new GradleSettingsQuickFix(issueData.getProjectPath(), true, check.gradleSettingsFix.1.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            quickFixes.add(gradleSettingsFix2);
            String suggestedJavaVersion = IncompatibleGradleJdkIssueChecker.Companion.getSuggestedJavaVersion(gradleVersionUsed, javaVersionUsed);
            issueDescription.append(" - Use Java " + suggestedJavaVersion + " as Gradle JVM: <a href=\"" + gradleSettingsFix2.getId() + "\">Open Gradle settings</a> \n");
        }
        String string = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
        String description = string;
        String string2 = BuildConsoleUtils.getMessageTitle((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessageTitle(description)");
        String title = string2;
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                this.description = $captured_local_variable$1;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)"Could not create service of type ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)" using BuildScopeServices.", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001c\u0010\u0015\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker$Companion;", "", "()V", "couldNotDetermineJavaPrefix", "", "causedByUnsafeDefineClassApiUsage", "", "gradleVersionUsed", "Lorg/gradle/util/GradleVersion;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "rootCause", "", "rootCauseText", "couldNotDetermineJavaIssue", "detectJavaVersion", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "getSuggestedGradleVersion", "newestCompatibleGradleVersion", "oldestCompatibleGradleVersion", "getSuggestedJavaVersion", "javaVersionUsed", "intellij.gradle.common"})
    public static final class Companion {
        private final boolean couldNotDetermineJavaIssue(String rootCauseText) {
            return StringsKt.startsWith$default((String)rootCauseText, (String)IncompatibleGradleJdkIssueChecker.couldNotDetermineJavaPrefix, (boolean)false, (int)2, null);
        }

        private final boolean causedByUnsafeDefineClassApiUsage(GradleVersion gradleVersionUsed, JavaVersion javaVersion, Throwable rootCause, String rootCauseText) {
            StackTraceElement stackTraceElement;
            block8: {
                boolean bl;
                GradleVersion gradleVersion = gradleVersionUsed;
                if (gradleVersion == null || (gradleVersion = gradleVersion.getBaseVersion()) == null) {
                    return false;
                }
                GradleVersion baseVersion = gradleVersion;
                if (baseVersion.compareTo(GradleVersion.version((String)"4.7")) > 0) {
                    return false;
                }
                if (StringsKt.startsWith$default((String)rootCauseText, (String)"java.lang.NoSuchMethodError: sun.misc.Unsafe.defineClass", (boolean)false, (int)2, null)) {
                    JavaVersion javaVersion2 = javaVersion;
                    if (javaVersion2 != null) {
                        int n = javaVersion2.feature;
                        boolean bl2 = false;
                        bl = false;
                        int it = n;
                        boolean bl3 = false;
                        if (it >= 11) {
                            return true;
                        }
                    }
                }
                String string = rootCause.getMessage();
                if (string == null) {
                    return false;
                }
                String message = string;
                if (!StringsKt.startsWith$default((String)message, (String)"'java.lang.Class sun.misc.Unsafe.defineClass", (boolean)false, (int)2, null)) {
                    return false;
                }
                StackTraceElement[] stackTraceElementArray = rootCause.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"rootCause.stackTrace");
                StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                bl = false;
                StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2;
                boolean bl4 = false;
                StackTraceElement[] stackTraceElementArray4 = stackTraceElementArray3;
                int n = stackTraceElementArray4.length;
                for (int j = 0; j < n; ++j) {
                    StackTraceElement stackTraceElement2;
                    StackTraceElement it = stackTraceElement2 = stackTraceElementArray4[j];
                    boolean bl5 = false;
                    StackTraceElement stackTraceElement3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement3, (String)"it");
                    if (!Intrinsics.areEqual((Object)stackTraceElement3.getClassName(), (Object)"org.gradle.internal.classloader.ClassLoaderUtils")) continue;
                    stackTraceElement = stackTraceElement2;
                    break block8;
                }
                stackTraceElement = null;
            }
            return stackTraceElement != null;
        }

        private final JavaVersion detectJavaVersion(boolean couldNotDetermineJavaIssue, String rootCauseText, GradleIssueData issueData) {
            Object object;
            if (couldNotDetermineJavaIssue) {
                File javaHomeCandidate;
                String javaExeCandidate = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)rootCauseText, (String)IncompatibleGradleJdkIssueChecker.couldNotDetermineJavaPrefix, null, (int)2, null), (char[])new char[]{'.'});
                File file = new File(javaExeCandidate).getParentFile();
                File file2 = javaHomeCandidate = file != null ? file.getParentFile() : null;
                if (file2 != null) {
                    File file3 = file2;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file3;
                    boolean bl3 = false;
                    if (it.isDirectory()) {
                        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(it.getPath());
                        object = jdkVersionInfo != null ? jdkVersionInfo.version : null;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
            } else {
                Object object2 = issueData.getBuildEnvironment();
                if (object2 != null && (object2 = object2.getJava()) != null && (object2 = object2.getJavaHome()) != null) {
                    Object object3 = object2;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object3;
                    boolean bl5 = false;
                    JdkVersionDetector.JdkVersionInfo jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(((File)it).getPath());
                    object = jdkVersionInfo != null ? jdkVersionInfo.version : null;
                } else {
                    object = null;
                }
            }
            return object;
        }

        private final String getSuggestedGradleVersion(GradleVersion newestCompatibleGradleVersion, GradleVersion oldestCompatibleGradleVersion) {
            return newestCompatibleGradleVersion != null && Intrinsics.areEqual((Object)newestCompatibleGradleVersion, (Object)oldestCompatibleGradleVersion) ^ true ? (Intrinsics.areEqual((Object)GradleVersion.current(), (Object)newestCompatibleGradleVersion) ? oldestCompatibleGradleVersion.getVersion() + " or newer" : "version from range [" + oldestCompatibleGradleVersion.getVersion() + ", " + newestCompatibleGradleVersion.getVersion() + ']') : (Intrinsics.areEqual((Object)GradleVersion.current(), (Object)oldestCompatibleGradleVersion) && Intrinsics.areEqual((Object)oldestCompatibleGradleVersion, (Object)newestCompatibleGradleVersion) ? oldestCompatibleGradleVersion.getVersion() + " or newer" : oldestCompatibleGradleVersion.getVersion());
        }

        private final String getSuggestedJavaVersion(GradleVersion gradleVersionUsed, JavaVersion javaVersionUsed) {
            GradleVersion gradleVersion;
            GradleVersion oldestCompatibleJavaVersion;
            String suggestedJavaVersion;
            block15: {
                block14: {
                    boolean bl;
                    GradleVersion gradleVersion2;
                    block13: {
                        block12: {
                            suggestedJavaVersion = null;
                            gradleVersion2 = gradleVersionUsed;
                            if (gradleVersion2 == null) break block12;
                            GradleVersion gradleVersion3 = gradleVersion2;
                            boolean bl2 = false;
                            bl = false;
                            GradleVersion it = gradleVersion3;
                            boolean bl3 = false;
                            gradleVersion2 = GradleJvmValidationUtil.suggestOldestCompatibleJavaVersion(it);
                            if (gradleVersion2 != null) break block13;
                        }
                        JavaVersion javaVersion = JavaVersion.compose((int)8);
                        gradleVersion2 = javaVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.compose(8)");
                    }
                    oldestCompatibleJavaVersion = gradleVersion2;
                    gradleVersion = gradleVersionUsed;
                    if (gradleVersion == null) break block14;
                    GradleVersion gradleVersion4 = gradleVersion;
                    bl = false;
                    boolean bl4 = false;
                    GradleVersion it = gradleVersion4;
                    boolean bl5 = false;
                    gradleVersion = GradleJvmValidationUtil.suggestJavaVersion(it);
                    if (gradleVersion != null) break block15;
                }
                JavaVersion javaVersion = JavaVersion.compose((int)8);
                gradleVersion = javaVersion;
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.compose(8)");
            }
            GradleVersion newestCompatibleJavaVersion = gradleVersion;
            if (javaVersionUsed != null) {
                if (javaVersionUsed.compareTo((JavaVersion)oldestCompatibleJavaVersion) < 0) {
                    String string = oldestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"oldestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string;
                } else if (javaVersionUsed.compareTo((JavaVersion)newestCompatibleJavaVersion) > 0) {
                    String string = newestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string;
                } else {
                    String string = newestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string;
                }
            } else {
                String string = newestCompatibleJavaVersion.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newestCompatibleJavaVersion.toString()");
                suggestedJavaVersion = string;
            }
            return suggestedJavaVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

