/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.internal;

import groovy.util.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.Collections2;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.DefaultScalaPlatform;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.ProjectLibrary;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;
import org.gradle.util.VersionNumber;

public class IdeaScalaConfigurer {
    private static final VersionNumber IDEA_VERSION_WHEN_SCALA_SDK_WAS_INTRODUCED = VersionNumber.version(14);
    private final Project rootProject;

    public IdeaScalaConfigurer(Project rootProject) {
        this.rootProject = rootProject;
    }

    public void configure() {
        this.rootProject.getGradle().projectsEvaluated((Action<? super Gradle>)new Action<Gradle>(){

            @Override
            public void execute(Gradle gradle) {
                VersionNumber ideaTargetVersion = IdeaScalaConfigurer.this.findIdeaTargetVersion();
                final boolean useScalaSdk = ideaTargetVersion == null || IDEA_VERSION_WHEN_SCALA_SDK_WAS_INTRODUCED.compareTo(ideaTargetVersion) <= 0;
                final Collection scalaProjects = IdeaScalaConfigurer.this.findProjectsApplyingIdeaAndScalaPlugins();
                final LinkedHashMap scalaCompilerLibraries = Maps.newLinkedHashMap();
                IdeaScalaConfigurer.this.rootProject.getTasks().named("ideaProject", new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        task.doFirst((Action<? super Task>)new Action<Task>(){

                            @Override
                            public void execute(Task task) {
                                if (scalaProjects.size() > 0) {
                                    scalaCompilerLibraries.clear();
                                    scalaCompilerLibraries.putAll(IdeaScalaConfigurer.resolveScalaCompilerLibraries(scalaProjects, useScalaSdk));
                                    IdeaScalaConfigurer.this.declareUniqueProjectLibraries(Sets.newLinkedHashSet(scalaCompilerLibraries.values()));
                                }
                            }
                        });
                    }
                });
                IdeaScalaConfigurer.this.rootProject.configure(scalaProjects, new Action<Project>(){

                    @Override
                    public void execute(final Project project) {
                        project.getExtensions().getByType(IdeaModel.class).getModule().getIml().withXml((Action<? super XmlProvider>)new Action<XmlProvider>(){

                            @Override
                            public void execute(XmlProvider xmlProvider) {
                                if (useScalaSdk) {
                                    IdeaScalaConfigurer.declareScalaSdk((ProjectLibrary)scalaCompilerLibraries.get(project.getPath()), xmlProvider.asNode());
                                } else {
                                    IdeaScalaConfigurer.declareScalaFacet((ProjectLibrary)scalaCompilerLibraries.get(project.getPath()), xmlProvider.asNode());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static Map<String, ProjectLibrary> resolveScalaCompilerLibraries(Collection<Project> scalaProjects, boolean useScalaSdk) {
        LinkedHashMap scalaCompilerLibraries = Maps.newLinkedHashMap();
        for (Project scalaProject : scalaProjects) {
            IdeaModule ideaModule = scalaProject.getExtensions().getByType(IdeaModel.class).getModule();
            Iterable<File> files2 = IdeaScalaConfigurer.getIdeaModuleLibraryDependenciesAsFiles(ideaModule);
            ProjectLibrary library = ((ProjectInternal)scalaProject).getMutationState().fromMutableState(p -> IdeaScalaConfigurer.createScalaSdkLibrary(scalaProject, files2, useScalaSdk, ideaModule));
            if (library == null) continue;
            ProjectLibrary duplicate = (ProjectLibrary)Iterables.find(scalaCompilerLibraries.values(), (Predicate)Predicates.equalTo((Object)library), null);
            scalaCompilerLibraries.put(scalaProject.getPath(), duplicate == null ? library : duplicate);
        }
        return scalaCompilerLibraries;
    }

    private static Iterable<File> getIdeaModuleLibraryDependenciesAsFiles(IdeaModule ideaModule) {
        Set<Dependency> dependencies = ideaModule.resolveDependencies();
        ArrayList files2 = Lists.newArrayList();
        for (ModuleLibrary moduleLibrary : Iterables.filter(dependencies, ModuleLibrary.class)) {
            for (FilePath filePath : Iterables.filter(moduleLibrary.getClasses(), FilePath.class)) {
                files2.add(filePath.getFile());
            }
        }
        return files2;
    }

    private static ProjectLibrary createScalaSdkLibrary(Project scalaProject, Iterable<File> files2, boolean useScalaSdk, IdeaModule ideaModule) {
        ScalaRuntime runtime = scalaProject.getExtensions().findByType(ScalaRuntime.class);
        if (runtime != null) {
            FileCollection scalaClasspath = runtime.inferScalaClasspath(files2);
            File compilerJar = runtime.findScalaJar(scalaClasspath, "compiler");
            DefaultScalaPlatform scalaPlatform = compilerJar != null ? new DefaultScalaPlatform(runtime.getScalaVersion(compilerJar)) : new DefaultScalaPlatform();
            return IdeaScalaConfigurer.createScalaSdkFromPlatform(scalaPlatform, scalaClasspath, useScalaSdk);
        }
        if (ideaModule.getScalaPlatform() != null) {
            return IdeaScalaConfigurer.createScalaSdkFromPlatform(ideaModule.getScalaPlatform(), scalaProject.getLayout().files(files2), useScalaSdk);
        }
        return null;
    }

    private static ProjectLibrary createScalaSdkFromPlatform(ScalaPlatform platform, FileCollection scalaClasspath, boolean useScalaSdk) {
        String version = platform.getScalaVersion();
        if (useScalaSdk) {
            return IdeaScalaConfigurer.createScalaSdkLibrary("scala-sdk-" + version, scalaClasspath);
        }
        return IdeaScalaConfigurer.createProjectLibrary("scala-compiler-" + version, scalaClasspath);
    }

    private void declareUniqueProjectLibraries(Set<ProjectLibrary> projectLibraries) {
        Set<ProjectLibrary> existingLibraries = this.rootProject.getExtensions().getByType(IdeaModel.class).getProject().getProjectLibraries();
        Sets.SetView newLibraries = Sets.difference(projectLibraries, existingLibraries);
        for (ProjectLibrary newLibrary : newLibraries) {
            String originalName = newLibrary.getName();
            int suffix = 1;
            while (IdeaScalaConfigurer.containsLibraryWithSameName(existingLibraries, newLibrary.getName())) {
                newLibrary.setName(originalName + "-" + suffix++);
            }
            existingLibraries.add(newLibrary);
        }
    }

    private static boolean containsLibraryWithSameName(Set<ProjectLibrary> libraries, String name) {
        return libraries.stream().anyMatch(library -> Objects.equal((Object)library.getName(), (Object)name));
    }

    private static void declareScalaSdk(ProjectLibrary scalaSdkLibrary, Node iml) {
        if (scalaSdkLibrary != null) {
            Node newModuleRootManager = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(iml, "component", "name", "NewModuleRootManager");
            Node sdkLibrary = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(newModuleRootManager, "orderEntry", "name", scalaSdkLibrary.getName());
            IdeaScalaConfigurer.setNodeAttribute(sdkLibrary, "type", "library");
            IdeaScalaConfigurer.setNodeAttribute(sdkLibrary, "level", "project");
        }
    }

    private static void declareScalaFacet(ProjectLibrary scalaCompilerLibrary, Node iml) {
        Node facetManager = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(iml, "component", "name", "FacetManager");
        Node scalaFacet = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(facetManager, "facet", "type", "scala");
        IdeaScalaConfigurer.setNodeAttribute(scalaFacet, "name", "Scala");
        Node configuration = XmlPersistableConfigurationObject.findOrCreateFirstChildNamed(scalaFacet, "configuration");
        Node libraryLevel = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(configuration, "option", "name", "compilerLibraryLevel");
        IdeaScalaConfigurer.setNodeAttribute(libraryLevel, "value", "Project");
        Node libraryName = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue(configuration, "option", "name", "compilerLibraryName");
        IdeaScalaConfigurer.setNodeAttribute(libraryName, "value", scalaCompilerLibrary.getName());
    }

    private static void setNodeAttribute(Node node, String key, String value) {
        Map attributes = (Map)Cast.uncheckedCast(node.attributes());
        attributes.put(key, value);
    }

    private Collection<Project> findProjectsApplyingIdeaAndScalaPlugins() {
        return Collections2.filter(this.rootProject.getAllprojects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                boolean hasIdeaPlugin = project.getPlugins().hasPlugin(IdeaPlugin.class);
                boolean hasScalaPlugin = project.getPlugins().hasPlugin(ScalaBasePlugin.class);
                boolean hasLegacyScalaPlugin = project.getPlugins().hasPlugin(ScalaLanguagePlugin.class);
                return hasIdeaPlugin && (hasScalaPlugin || hasLegacyScalaPlugin);
            }
        });
    }

    private VersionNumber findIdeaTargetVersion() {
        VersionNumber targetVersion = null;
        String targetVersionString = this.rootProject.getExtensions().getByType(IdeaModel.class).getTargetVersion();
        if (targetVersionString != null && (targetVersion = VersionNumber.parse(targetVersionString)).equals(VersionNumber.UNKNOWN)) {
            throw new GradleScriptException("String '" + targetVersionString + "' is not a valid value for IdeaModel.targetVersion.", null);
        }
        return targetVersion;
    }

    private static ProjectLibrary createProjectLibrary(String name, Iterable<File> jars) {
        ProjectLibrary projectLibrary = new ProjectLibrary();
        projectLibrary.setName(name);
        projectLibrary.setClasses(Sets.newLinkedHashSet(jars));
        return projectLibrary;
    }

    private static ProjectLibrary createScalaSdkLibrary(String name, Iterable<File> jars) {
        ProjectLibrary projectLibrary = new ProjectLibrary();
        projectLibrary.setName(name);
        projectLibrary.setType("Scala");
        projectLibrary.setCompilerClasspath(Sets.newLinkedHashSet(jars));
        return projectLibrary;
    }
}

