/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.nativeplatform.platform.Architecture;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCpp;
import org.gradle.util.VersionNumber;

public class VisualCppInstall
implements Named {
    private final Map<Architecture, ? extends VisualCpp> platforms;
    private final String name;
    private final VersionNumber version;

    public VisualCppInstall(String name, VersionNumber version, Map<Architecture, ? extends VisualCpp> platforms) {
        this.name = name;
        this.version = version;
        this.platforms = platforms;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    @Nullable
    public VisualCpp forPlatform(NativePlatformInternal targetPlatform) {
        if (!targetPlatform.getOperatingSystem().isWindows()) {
            return null;
        }
        return this.platforms.get(this.getPlatformArchitecture(targetPlatform));
    }

    private Architecture getPlatformArchitecture(NativePlatformInternal targetPlatform) {
        return targetPlatform.getArchitecture();
    }

    private VisualCpp getDescriptor(NativePlatformInternal targetPlatform) {
        return this.platforms.get(this.getPlatformArchitecture(targetPlatform));
    }
}

