/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal;

import org.gradle.language.scala.ScalaPlatform;
import org.gradle.util.VersionNumber;

public class DefaultScalaPlatform
implements ScalaPlatform {
    public static final String DEFAULT_SCALA_PLATFORM_VERSION = "2.10.7";
    private final String scalaCompatibilityVersion;
    private final String scalaVersion;

    public DefaultScalaPlatform() {
        this(DEFAULT_SCALA_PLATFORM_VERSION);
    }

    public DefaultScalaPlatform(String scalaVersion) {
        this(VersionNumber.parse(scalaVersion));
    }

    public DefaultScalaPlatform(VersionNumber versionNumber) {
        this.scalaVersion = versionNumber.getMajor() + "." + versionNumber.getMinor() + "." + versionNumber.getMicro();
        this.scalaCompatibilityVersion = versionNumber.getMajor() + "." + versionNumber.getMinor();
    }

    @Override
    public String getScalaVersion() {
        return this.scalaVersion;
    }

    @Override
    public String getScalaCompatibilityVersion() {
        return this.scalaCompatibilityVersion;
    }

    @Override
    public String getDisplayName() {
        return "Scala Platform (Scala " + this.scalaVersion + ")";
    }

    @Override
    public String getName() {
        return "ScalaPlatform" + this.scalaVersion;
    }
}

