/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.impldep.com.google.common.base.Joiner;

public class FormattingDiagnosticsVisitor
implements DiagnosticsVisitor {
    private final Map<String, Candidate> candidates = new LinkedHashMap<String, Candidate>();
    private Candidate current;

    public List<String> getCandidates() {
        return this.format(this.candidates);
    }

    private List<String> format(Map<String, Candidate> candidates) {
        ArrayList<String> formatted = new ArrayList<String>();
        for (Candidate candidate : candidates.values()) {
            if (candidate.examples.isEmpty()) {
                formatted.add(candidate.description);
                continue;
            }
            formatted.add(String.format("%s, for example %s.", candidate.description, Joiner.on((String)", ").join(candidate.examples)));
        }
        return formatted;
    }

    @Override
    public DiagnosticsVisitor candidate(String displayName) {
        Candidate candidate = this.candidates.get(displayName);
        if (candidate == null) {
            candidate = new Candidate(displayName);
            this.candidates.put(displayName, candidate);
        }
        this.current = candidate;
        return this;
    }

    @Override
    public DiagnosticsVisitor example(String example) {
        this.current.examples.add(example);
        return this;
    }

    @Override
    public DiagnosticsVisitor values(Iterable<?> values) {
        return this;
    }

    private static class Candidate {
        final String description;
        final List<String> examples = new ArrayList<String>();

        public Candidate(String description) {
            this.description = description;
        }
    }
}

