/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommandLineOption {
    private final Set<String> options = new HashSet<String>();
    private Class<?> argumentType = Void.TYPE;
    private String description;
    private boolean incubating;
    private final Set<CommandLineOption> groupWith = new HashSet<CommandLineOption>();
    private boolean deprecated;

    public CommandLineOption(Iterable<String> options) {
        for (String option : options) {
            this.options.add(option);
        }
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public CommandLineOption hasArgument(Class<?> argumentType) {
        this.argumentType = argumentType;
        return this;
    }

    public CommandLineOption hasArgument() {
        this.argumentType = String.class;
        return this;
    }

    public CommandLineOption hasArguments() {
        this.argumentType = List.class;
        return this;
    }

    public String getDescription() {
        StringBuilder result = new StringBuilder();
        if (this.description != null) {
            result.append(this.description);
        }
        this.appendMessage(result, this.deprecated, "[deprecated]");
        this.appendMessage(result, this.incubating, "[incubating]");
        return result.toString();
    }

    private void appendMessage(StringBuilder result, boolean append, String message2) {
        if (append) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(message2);
        }
    }

    public CommandLineOption hasDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean getAllowsArguments() {
        return this.argumentType != Void.TYPE;
    }

    public boolean getAllowsMultipleArguments() {
        return this.argumentType == List.class;
    }

    public CommandLineOption deprecated() {
        this.deprecated = true;
        return this;
    }

    public CommandLineOption incubating() {
        this.incubating = true;
        return this;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isIncubating() {
        return this.incubating;
    }

    Set<CommandLineOption> getGroupWith() {
        return this.groupWith;
    }

    void groupWith(Set<CommandLineOption> options) {
        this.groupWith.addAll(options);
        this.groupWith.remove(this);
    }
}

