/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.FinalizeBuildCacheConfigurationBuildOperationType;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultBuildCacheController;
import org.gradle.caching.internal.controller.NoOpBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildCacheControllerFactory {
    public static final String REMOTE_CONTINUE_ON_ERROR_PROPERTY = "org.gradle.unsafe.build-cache.remote-continue-on-error";
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheControllerFactory.class);

    public static BuildCacheController create(final BuildOperationExecutor buildOperationExecutor, final Path buildIdentityPath, final File gradleUserHomeDir, final BuildCacheConfigurationInternal buildCacheConfiguration, final BuildCacheMode buildCacheState, final RemoteAccessMode remoteAccessMode, final boolean logStackTraces, final boolean emitDebugLogging, final Instantiator instantiator) {
        return buildOperationExecutor.call(new CallableBuildOperation<BuildCacheController>(){

            @Override
            public BuildCacheController call(BuildOperationContext context) {
                boolean remoteEnabled;
                if (buildCacheState == BuildCacheMode.DISABLED) {
                    context.setResult(ResultImpl.disabled());
                    return NoOpBuildCacheController.INSTANCE;
                }
                DirectoryBuildCache local = buildCacheConfiguration.getLocal();
                BuildCache remote = buildCacheConfiguration.getRemote();
                boolean localEnabled = local.isEnabled();
                boolean bl = remoteEnabled = remote != null && remote.isEnabled();
                if (remoteEnabled && remoteAccessMode == RemoteAccessMode.OFFLINE) {
                    remoteEnabled = false;
                    LOGGER.warn("Remote build cache is disabled when running with --offline.");
                }
                DescribedBuildCacheService localDescribedService = localEnabled ? BuildCacheControllerFactory.createBuildCacheService(local, BuildCacheServiceRole.LOCAL, buildIdentityPath, buildCacheConfiguration, instantiator) : null;
                DescribedBuildCacheService remoteDescribedService = remoteEnabled ? BuildCacheControllerFactory.createBuildCacheService(remote, BuildCacheServiceRole.REMOTE, buildIdentityPath, buildCacheConfiguration, instantiator) : null;
                context.setResult(new ResultImpl(true, local.isEnabled(), remote != null && remote.isEnabled() && remoteAccessMode == RemoteAccessMode.ONLINE, localDescribedService == null ? null : localDescribedService.description, remoteDescribedService == null ? null : remoteDescribedService.description));
                if (!localEnabled && !remoteEnabled) {
                    LOGGER.warn("Using the build cache is enabled, but no build caches are configured or enabled.");
                    return NoOpBuildCacheController.INSTANCE;
                }
                BuildCacheServicesConfiguration config = BuildCacheControllerFactory.toConfiguration(localDescribedService, remoteDescribedService);
                return new DefaultBuildCacheController(config, buildOperationExecutor, gradleUserHomeDir, logStackTraces, emitDebugLogging, !Boolean.getBoolean(BuildCacheControllerFactory.REMOTE_CONTINUE_ON_ERROR_PROPERTY));
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Finalize build cache configuration").details(new DetailsImpl(buildIdentityPath.getPath()));
            }
        });
    }

    private static BuildCacheServicesConfiguration toConfiguration(@Nullable DescribedBuildCacheService<DirectoryBuildCache, DirectoryBuildCacheService> local, @Nullable DescribedBuildCacheService<BuildCache, BuildCacheService> remote) {
        boolean localPush = local != null && ((DirectoryBuildCache)((DescribedBuildCacheService)local).config).isPush();
        boolean remotePush = remote != null && ((BuildCache)((DescribedBuildCacheService)remote).config).isPush();
        return new BuildCacheServicesConfiguration(local != null ? (LocalBuildCacheService)((DescribedBuildCacheService)local).service : null, localPush, remote != null ? (BuildCacheService)((DescribedBuildCacheService)remote).service : null, remotePush);
    }

    private static <C extends BuildCache, S> DescribedBuildCacheService<C, S> createBuildCacheService(C configuration, BuildCacheServiceRole role, Path buildIdentityPath, BuildCacheConfigurationInternal buildCacheConfiguration, Instantiator instantiator) {
        Class castFactoryType = (Class)Cast.uncheckedNonnullCast(buildCacheConfiguration.getBuildCacheServiceFactoryType(configuration.getClass()));
        BuildCacheServiceFactory factory = (BuildCacheServiceFactory)instantiator.newInstance(castFactoryType, new Object[0]);
        Describer describer = new Describer();
        Object service = Cast.uncheckedNonnullCast(factory.createBuildCacheService(configuration, describer));
        ImmutableSortedMap config = ImmutableSortedMap.copyOf((Map)describer.configParams);
        BuildCacheDescription description = new BuildCacheDescription(configuration, describer.type, config);
        BuildCacheControllerFactory.logConfig(buildIdentityPath, role, description);
        return new DescribedBuildCacheService(configuration, service, description);
    }

    private static void logConfig(Path buildIdentityPath, BuildCacheServiceRole role, BuildCacheDescription description) {
        if (LOGGER.isInfoEnabled()) {
            boolean pullOnly;
            StringBuilder config = new StringBuilder();
            boolean bl = pullOnly = !description.isPush();
            if (!description.config.isEmpty() || pullOnly) {
                Object configMap;
                if (pullOnly) {
                    configMap = new LinkedHashMap();
                    configMap.put("pull-only", null);
                    configMap.putAll(description.config);
                } else {
                    configMap = description.config;
                }
                config.append(" (");
                config.append(configMap.entrySet().stream().map(input -> {
                    if (input.getValue() == null) {
                        return (String)input.getKey();
                    }
                    return (String)input.getKey() + " = " + (String)input.getValue();
                }).collect(Collectors.joining(", ")));
                config.append(")");
            }
            String buildDescription = buildIdentityPath.equals(Path.ROOT) ? "the root build" : "build '" + buildIdentityPath + "'";
            LOGGER.info("Using {} {} build cache for {}{}.", new Object[]{role.getDisplayName(), description.type == null ? description.className : description.type, buildDescription, config});
        }
    }

    private static class ResultImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result {
        private final boolean enabled;
        private final boolean localEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local;
        private final boolean remoteEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote;

        ResultImpl(boolean enabled, boolean localEnabled, boolean remoteEnabled, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote) {
            this.enabled = enabled;
            this.localEnabled = localEnabled;
            this.remoteEnabled = remoteEnabled;
            this.local = local;
            this.remote = remote;
        }

        static FinalizeBuildCacheConfigurationBuildOperationType.Result disabled() {
            return new ResultImpl(false, false, false, null, null);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean isLocalEnabled() {
            return this.localEnabled;
        }

        @Override
        public boolean isRemoteEnabled() {
            return this.remoteEnabled;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getLocal() {
            return this.local;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getRemote() {
            return this.remote;
        }
    }

    private static class DetailsImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Details {
        private final String buildPath;

        private DetailsImpl(String buildPath) {
            this.buildPath = buildPath;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }
    }

    private static class DescribedBuildCacheService<C, S> {
        private final C config;
        private final S service;
        private final BuildCacheDescription description;

        public DescribedBuildCacheService(C config, S service, BuildCacheDescription description) {
            this.config = config;
            this.service = service;
            this.description = description;
        }
    }

    private static class Describer
    implements BuildCacheServiceFactory.Describer {
        private String type;
        private Map<String, String> configParams = new HashMap<String, String>();

        private Describer() {
        }

        @Override
        public BuildCacheServiceFactory.Describer type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"'type' argument cannot be null");
            return this;
        }

        @Override
        public BuildCacheServiceFactory.Describer config(String name, String value) {
            Preconditions.checkNotNull((Object)name, (Object)"'name' argument cannot be null");
            Preconditions.checkNotNull((Object)value, (Object)"'value' argument cannot be null");
            this.configParams.put(name, value);
            return this;
        }
    }

    private static final class BuildCacheDescription
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription {
        private final String className;
        private final boolean push;
        private final String type;
        private final ImmutableSortedMap<String, String> config;

        private BuildCacheDescription(BuildCache buildCache, String type, ImmutableSortedMap<String, String> config) {
            this.className = GeneratedSubclasses.unpackType(buildCache).getName();
            this.push = buildCache.isPush();
            this.type = type;
            this.config = config;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public boolean isPush() {
            return this.push;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Map<String, String> getConfig() {
            return this.config;
        }
    }

    public static enum RemoteAccessMode {
        ONLINE,
        OFFLINE;

    }

    public static enum BuildCacheMode {
        ENABLED,
        DISABLED;

    }
}

