/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

public class FixedSharedModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Action<FileLock> onOpenAction;
    private final Action<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedSharedModeCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, CacheInitializationAction initializationAction, Action<FileLock> onOpenAction, Action<FileLock> onCloseAction) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Shared);
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
        this.initializationAction = initializationAction;
        this.onOpenAction = onOpenAction;
        this.onCloseAction = onCloseAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
        try {
            boolean rebuild = this.initializationAction.requiresInitialization(fileLock);
            if (rebuild) {
                Exception latestException = null;
                for (int tries = 0; rebuild && tries < 3; ++tries) {
                    fileLock.close();
                    fileLock = null;
                    FileLock exclusiveLock = null;
                    try {
                        exclusiveLock = this.lockManager.lock(this.lockTarget, this.lockOptions.withMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName);
                    }
                    catch (Exception e) {
                        latestException = e;
                    }
                    try {
                        FileLock acquiredExclusiveLock;
                        if (exclusiveLock != null && (rebuild = this.initializationAction.requiresInitialization(acquiredExclusiveLock = exclusiveLock))) {
                            exclusiveLock.writeFile(new Runnable(){

                                @Override
                                public void run() {
                                    FixedSharedModeCrossProcessCacheAccess.this.initializationAction.initialize(acquiredExclusiveLock);
                                }
                            });
                        }
                    }
                    finally {
                        if (exclusiveLock != null) {
                            exclusiveLock.close();
                        }
                    }
                    fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
                    rebuild = this.initializationAction.requiresInitialization(fileLock);
                }
                if (rebuild) {
                    throw new CacheOpenException(String.format("Failed to initialize %s", this.cacheDisplayName), latestException);
                }
            }
            this.onOpenAction.execute(fileLock);
        }
        catch (Exception e) {
            if (fileLock != null) {
                fileLock.close();
            }
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.fileLock = fileLock;
    }

    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.execute(this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        throw this.failure();
    }

    @Override
    public <T> T withFileLock(Factory<T> factory) {
        throw this.failure();
    }

    protected UnsupportedOperationException failure() {
        return new UnsupportedOperationException("Cannot escalate a shared lock to an exclusive lock. This is not yet supported.");
    }
}

