/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.scala.internal.ScaladocParameters;
import org.gradle.internal.process.ArgWriter;
import org.gradle.workers.WorkAction;

public abstract class GenerateScaladoc
implements WorkAction<ScaladocParameters> {
    @Override
    public void execute() {
        Path optionsFile = this.getOptionsPath();
        try {
            ScaladocParameters parameters = (ScaladocParameters)this.getParameters();
            List<String> args = this.generateArgList(parameters, optionsFile);
            this.invokeScalaDoc(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not generate scaladoc", e);
        }
        finally {
            if (optionsFile != null) {
                optionsFile.toFile().delete();
            }
        }
    }

    private Path getOptionsPath() {
        Path optionsFile = null;
        try {
            optionsFile = Files.createTempFile("scaladoc", "options", new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return optionsFile;
    }

    private List<String> generateArgList(ScaladocParameters parameters, Path optionsFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(((Directory)parameters.getOutputDirectory().get()).getAsFile().getAbsolutePath());
        args.add("-classpath");
        args.add(parameters.getClasspath().getAsPath());
        args.addAll((Collection)parameters.getOptions().get());
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File sourceFile : parameters.getSources().getAsFileTree().getFiles()) {
            sourceFiles.add(sourceFile.getAbsolutePath());
        }
        args.addAll(sourceFiles);
        if (optionsFile != null) {
            ArgWriter.argsFileGenerator(optionsFile.toFile(), ArgWriter.javaStyleFactory()).transform(args);
        }
        return args;
    }

    private void invokeScalaDoc(List<String> args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> scaladocClass = Thread.currentThread().getContextClassLoader().loadClass("scala.tools.nsc.ScalaDoc");
        Method process = scaladocClass.getMethod("process", String[].class);
        Object scaladoc = scaladocClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        process.invoke(scaladoc, new Object[]{args.toArray(new String[0])});
    }
}

