/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class UnresolvableConfigurationResult
extends AbstractRenderableDependency {
    private final Configuration configuration;

    public UnresolvableConfigurationResult(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Object getId() {
        return this.configuration;
    }

    @Override
    public String getName() {
        return this.configuration.getAsPath();
    }

    @Override
    public String getDescription() {
        return this.configuration.getDescription() + "(n)";
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return RenderableDependency.ResolutionState.UNRESOLVED;
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        DependencySet dependencies = this.configuration.getDependencies();
        if (dependencies.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet children = Sets.newLinkedHashSet();
        for (final Dependency dependency : dependencies) {
            children.add(new AbstractRenderableDependency(){

                @Override
                public Object getId() {
                    return dependency;
                }

                @Override
                public String getName() {
                    String label = dependency instanceof ProjectDependency ? "project " + dependency.getName() : Joiner.on((String)":").join((Iterable)Stream.of(dependency.getGroup(), dependency.getName(), dependency.getVersion()).filter(Objects::nonNull).collect(Collectors.toList()));
                    return label;
                }
            });
        }
        return children;
    }
}

