/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Describable;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.util.ConfigureUtil;

public abstract class SimpleReport
implements ConfigurableReport {
    private final String name;
    private final Describable displayName;
    private final Report.OutputType outputType;

    public SimpleReport(String name, Describable displayName, Report.OutputType outputType) {
        this.name = name;
        this.displayName = displayName;
        this.outputType = outputType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public String toString() {
        return "Report " + this.getName();
    }

    public abstract FileSystemLocationProperty<? extends FileSystemLocation> getOutputLocation();

    @Override
    public File getDestination() {
        return this.getOutputLocation().getAsFile().getOrNull();
    }

    @Override
    public void setDestination(File file) {
        this.getOutputLocation().fileValue(file);
    }

    @Override
    public void setDestination(Provider<File> provider) {
        this.getOutputLocation().fileProvider(provider);
    }

    @Override
    public Report.OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public Report configure(Closure configure) {
        return ConfigureUtil.configureSelf(configure, this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getRequired().get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getRequired().set(enabled);
    }

    @Override
    public void setEnabled(Provider<Boolean> enabled) {
        this.getRequired().set(enabled);
    }
}

