/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import java.net.URI;
import java.util.Collection;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public final class MavenRepositoryDescriptor
extends UrlRepositoryDescriptor {
    public final ImmutableList<URI> artifactUrls;

    private MavenRepositoryDescriptor(String name, URI url, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes, ImmutableList<URI> artifactUrls) {
        super(name, url, metadataSources, authenticated, authenticationSchemes);
        this.artifactUrls = artifactUrls;
    }

    @Override
    public RepositoryDescriptor.Type getType() {
        return RepositoryDescriptor.Type.MAVEN;
    }

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        super.addProperties(builder);
        builder.put((Object)Property.ARTIFACT_URLS.name(), this.artifactUrls);
    }

    public static class Builder
    extends UrlRepositoryDescriptor.Builder<Builder> {
        private ImmutableList<URI> artifactUrls;

        public Builder(String name, URI url) {
            super(name, url);
        }

        public Builder setArtifactUrls(Collection<URI> artifactUrls) {
            this.artifactUrls = ImmutableList.copyOf(artifactUrls);
            return this;
        }

        public MavenRepositoryDescriptor create() {
            return new MavenRepositoryDescriptor((String)Preconditions.checkNotNull((Object)this.name), this.url, (ImmutableList)Preconditions.checkNotNull((Object)this.metadataSources), (Boolean)Preconditions.checkNotNull((Object)this.authenticated), (ImmutableList)Preconditions.checkNotNull((Object)this.authenticationSchemes), (ImmutableList)Preconditions.checkNotNull(this.artifactUrls));
        }
    }

    private static enum Property {
        ARTIFACT_URLS;

    }
}

