/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ComponentSelectionReasonSerializer
implements Serializer<ComponentSelectionReason> {
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;

    public ComponentSelectionReasonSerializer(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory) {
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
    }

    @Override
    public ComponentSelectionReason read(Decoder decoder) throws IOException {
        ComponentSelectionDescriptor[] descriptions = this.readDescriptions(decoder);
        return ComponentSelectionReasons.of(descriptions);
    }

    private ComponentSelectionDescriptor[] readDescriptions(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ComponentSelectionDescriptor[] descriptors = new ComponentSelectionDescriptor[size];
        for (int i = 0; i < size; ++i) {
            String defaultReason;
            ComponentSelectionCause cause = ComponentSelectionCause.values()[decoder.readByte()];
            String desc = this.readDescriptionText(decoder);
            descriptors[i] = desc.equals(defaultReason = cause.getDefaultReason()) ? this.componentSelectionDescriptorFactory.newDescriptor(cause) : this.componentSelectionDescriptorFactory.newDescriptor(cause, desc);
        }
        return descriptors;
    }

    private String readDescriptionText(Decoder decoder) throws IOException {
        return decoder.readString();
    }

    @Override
    public void write(Encoder encoder, ComponentSelectionReason value) throws IOException {
        List<ComponentSelectionDescriptor> descriptions = value.getDescriptions();
        encoder.writeSmallInt(descriptions.size());
        for (ComponentSelectionDescriptor description : descriptions) {
            this.writeDescription(encoder, description);
        }
    }

    private void writeDescription(Encoder encoder, ComponentSelectionDescriptor description) throws IOException {
        encoder.writeByte((byte)description.getCause().ordinal());
        this.writeDescriptionText(encoder, description.getDescription());
    }

    private void writeDescriptionText(Encoder encoder, String description) throws IOException {
        encoder.writeString(description);
    }
}

