/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Date;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class LazyPublishArtifact
implements PublishArtifactInternal {
    private final ProviderInternal<?> provider;
    private final String version;
    private final FileResolver fileResolver;
    private PublishArtifactInternal delegate;

    public LazyPublishArtifact(Provider<?> provider) {
        this.provider = Providers.internal(provider);
        this.version = null;
        this.fileResolver = null;
    }

    public LazyPublishArtifact(Provider<?> provider, FileResolver fileResolver) {
        this.provider = Providers.internal(provider);
        this.version = null;
        this.fileResolver = fileResolver;
    }

    public LazyPublishArtifact(Provider<?> provider, String version) {
        this.provider = Providers.internal(provider);
        this.version = version;
        this.fileResolver = null;
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getExtension() {
        return this.getDelegate().getExtension();
    }

    @Override
    public String getType() {
        return this.getDelegate().getType();
    }

    @Override
    public String getClassifier() {
        return this.getDelegate().getClassifier();
    }

    @Override
    public File getFile() {
        return this.getDelegate().getFile();
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    private PublishArtifact getDelegate() {
        if (this.delegate == null) {
            Object value = this.provider.get();
            if (value instanceof FileSystemLocation) {
                FileSystemLocation location = (FileSystemLocation)value;
                this.delegate = this.fromFile(location.getAsFile());
            } else if (value instanceof File) {
                this.delegate = this.fromFile((File)value);
            } else if (value instanceof AbstractArchiveTask) {
                this.delegate = new ArchivePublishArtifact((AbstractArchiveTask)value);
            } else if (value instanceof Task) {
                this.delegate = this.fromFile(((Task)value).getOutputs().getFiles().getSingleFile());
            } else if (value instanceof CharSequence && this.fileResolver != null) {
                this.delegate = this.fromFile(this.fileResolver.resolve(value.toString()));
            } else {
                throw new InvalidUserDataException(String.format("Cannot convert provided value (%s) to a file.", value));
            }
        }
        return this.delegate;
    }

    private DefaultPublishArtifact fromFile(File file) {
        ArtifactFile artifactFile = new ArtifactFile(file, this.version);
        return new DefaultPublishArtifact(artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Object[0]);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(LazyPublishArtifact.this.provider);
            }
        };
    }

    @Override
    public boolean shouldBePublished() {
        return ((PublishArtifactInternal)this.getDelegate()).shouldBePublished();
    }
}

