/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.fetch.GitFetchSupport;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoBasic;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubSelectForkDialog;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public final class GithubCreatePullRequestWorker {
    private static final Logger LOG = GithubUtil.LOG;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myGitRepository;
    @NotNull
    private final GithubApiRequestExecutor myExecutor;
    @NotNull
    private final GithubServerPath myServer;
    @NotNull
    private final GithubGitHelper myGitHelper;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final GHRepositoryPath myPath;
    @NotNull
    private final String myRemoteName;
    @NotNull
    private final String myRemoteUrl;
    @NlsSafe
    @NotNull
    private final String myCurrentBranch;
    @NotNull
    private GHRepositoryPath mySource;
    @NotNull
    private final List<ForkInfo> myForks;
    @Nullable
    private List<GHRepositoryPath> myAvailableForks;

    private GithubCreatePullRequestWorker(@NotNull Project project, @NotNull Git git, @NotNull GitRepository gitRepository, @NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server, @NotNull GithubGitHelper helper, @NotNull ProgressManager progressManager, @NotNull GHRepositoryPath path, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String currentBranch) {
        if (project == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(1);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(3);
        }
        if (server == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(5);
        }
        if (progressManager == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(6);
        }
        if (path == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(7);
        }
        if (remoteName == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(8);
        }
        if (remoteUrl == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(9);
        }
        if (currentBranch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(10);
        }
        this.myProject = project;
        this.myGit = git;
        this.myGitRepository = gitRepository;
        this.myExecutor = executor;
        this.myServer = server;
        this.myGitHelper = helper;
        this.myProgressManager = progressManager;
        this.myPath = path;
        this.myRemoteName = remoteName;
        this.myRemoteUrl = remoteUrl;
        this.myCurrentBranch = currentBranch;
        this.myForks = new ArrayList<ForkInfo>();
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<ForkInfo> getForks() {
        List<ForkInfo> list2 = this.myForks;
        if (list2 == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private void initForks(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(13);
        }
        this.doLoadForksFromGithub(indicator);
        this.doLoadForksFromGit(indicator);
        this.doLoadForksFromSettings(indicator);
    }

    private void doConfigureRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(14);
        }
        if (fork.getRemoteName() != null) {
            return;
        }
        GHRepositoryPath path = fork.getPath();
        String url = this.myGitHelper.getRemoteUrl(this.myServer, path);
        try {
            this.myGit.addRemote(this.myGitRepository, path.getOwner(), url).throwOnError(new int[0]);
            this.myGitRepository.update();
            fork.setRemoteName(path.getOwner());
        }
        catch (VcsException e) {
            GithubNotifications.showError(this.myProject, "github.pull.request.failed.to.add.remote", GithubBundle.message("pull.request.cannot.add.remote", new Object[0]), GithubBundle.message("pull.request.create.add.remote.failed", url, e.getMessage()));
        }
    }

    private void doAddFork(@NotNull GHRepositoryPath path, @Nullable String remoteName, @NotNull ProgressIndicator indicator) {
        if (path == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(16);
        }
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            if (fork.getRemoteName() == null && remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = this.doLoadDefaultBranch(path, indicator);
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            if (remoteName != null) {
                fork.setRemoteName(remoteName);
            }
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "github.pull.request.cannot.load.branches", GithubBundle.message("pull.request.cannot.load.branches", path), e);
        }
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubRepo repo, @NotNull ProgressIndicator indicator) {
        if (repo == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(18);
        }
        GHRepositoryPath path = repo.getFullPath();
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = repo.getDefaultBranch();
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "github.pull.request.cannot.load.branches", GithubBundle.message("pull.request.cannot.load.branches", path), e);
            return null;
        }
    }

    private void doLoadForksFromSettings(@NotNull ProgressIndicator indicator) {
        GHRepositoryPath savedRepo;
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(19);
        }
        if ((savedRepo = GithubProjectSettings.getInstance(this.myProject).getCreatePullRequestDefaultRepo()) != null) {
            this.doAddFork(savedRepo, null, indicator);
        }
    }

    private void doLoadForksFromGit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(20);
        }
        block0: for (GitRemote remote : this.myGitRepository.getRemotes()) {
            for (String url : remote.getUrls()) {
                GHRepositoryPath path;
                if (!this.myServer.matches(url) || (path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url)) == null) continue;
                this.doAddFork(path, remote.getName(), indicator);
                continue block0;
            }
        }
    }

    private void doLoadForksFromGithub(@NotNull ProgressIndicator indicator) throws IOException {
        GithubRepoDetailed repo;
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(21);
        }
        if ((repo = this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, this.myPath.getOwner(), this.myPath.getRepository()))) == null) {
            throw new GithubConfusingException("Can't find github repo " + this.myPath.toString());
        }
        this.doAddFork(repo, indicator);
        if (repo.getParent() != null) {
            this.doAddFork(repo.getParent(), indicator);
        }
        if (repo.getSource() != null) {
            this.doAddFork(repo.getSource(), indicator);
        }
        this.mySource = repo.getSource() == null ? repo.getFullPath() : repo.getSource().getFullPath();
    }

    @NotNull
    private List<String> loadBranches(@NotNull GHRepositoryPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(23);
        }
        List<GithubBranch> branches = GithubApiPagesLoader.loadAll(this.myExecutor, indicator, GithubApiRequests.Repos.Branches.pages(this.myServer, fork.getOwner(), fork.getRepository()));
        List list2 = ContainerUtil.map(branches, GithubBranch::getName);
        if (list2 == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @Nullable
    private String doLoadDefaultBranch(@NotNull GHRepositoryPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        GithubRepo repo;
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(26);
        }
        if ((repo = (GithubRepo)this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, fork.getOwner(), fork.getRepository()))) == null) {
            throw new GithubConfusingException("Can't find github repo " + fork.toString());
        }
        return repo.getDefaultBranch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchFetchRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(27);
        }
        if (fork.getRemoteName() == null) {
            return;
        }
        if (fork.getFetchTask() != null) {
            return;
        }
        Object object = fork.LOCK;
        synchronized (object) {
            if (fork.getFetchTask() != null) {
                return;
            }
            MasterFutureTask<Void> task2 = new MasterFutureTask<Void>(() -> {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> this.doFetchRemote(fork));
                return null;
            });
            fork.setFetchTask(task2);
            ApplicationManager.getApplication().executeOnPooledThread(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchLoadDiffInfo(@NotNull BranchInfo branch) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(28);
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return;
        }
        if (branch.getDiffInfoTask() != null) {
            return;
        }
        Object object = branch.LOCK;
        synchronized (object) {
            if (branch.getDiffInfoTask() != null) {
                return;
            }
            this.launchFetchRemote(branch.getForkInfo());
            MasterFutureTask<Void> masterTask = branch.getForkInfo().getFetchTask();
            assert (masterTask != null);
            SlaveFutureTask<DiffInfo> task2 = new SlaveFutureTask<DiffInfo>(masterTask, () -> this.doLoadDiffInfo(branch));
            branch.setDiffInfoTask(task2);
            ApplicationManager.getApplication().executeOnPooledThread(task2);
        }
    }

    @Nullable
    public DiffInfo getDiffInfo(@NotNull BranchInfo branch) throws IOException {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(29);
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return null;
        }
        this.launchLoadDiffInfo(branch);
        assert (branch.getDiffInfoTask() != null);
        try {
            return (DiffInfo)branch.getDiffInfoTask().get();
        }
        catch (InterruptedException e) {
            throw new GithubOperationCanceledException(e);
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof VcsException) {
                throw new IOException(ex);
            }
            LOG.error(ex);
            return null;
        }
    }

    private void doFetchRemote(@NotNull ForkInfo fork) {
        String remoteName;
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(30);
        }
        if ((remoteName = fork.getRemoteName()) == null) {
            return;
        }
        GitRemote remote = GitUtil.findRemoteByName((GitRepository)this.myGitRepository, (String)remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote " + remoteName + " in " + this.myGitRepository);
        }
        GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myGitRepository, remote).showNotificationIfFailed();
    }

    @NotNull
    private DiffInfo doLoadDiffInfo(@NotNull BranchInfo branch) throws VcsException {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(31);
        }
        String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
        List commits1 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{".." + targetBranch});
        List commits2 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{targetBranch + ".."});
        Collection diff = GitChangeUtils.getDiff((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String)targetBranch, (String)this.myCurrentBranch, null);
        CommitCompareInfo info = new CommitCompareInfo(CommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        info.putTotalDiff((Repository)this.myGitRepository, diff);
        info.put((Repository)this.myGitRepository, commits1, commits2);
        return new DiffInfo(info, this.myCurrentBranch, targetBranch);
    }

    @Nullable
    private GithubPullRequestDetailed doCreatePullRequest(@NotNull ProgressIndicator indicator, @NotNull BranchInfo branch, @NotNull String title, @NotNull String description) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(32);
        }
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(33);
        }
        if (title == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(34);
        }
        if (description == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(35);
        }
        GHRepositoryPath forkPath = branch.getForkInfo().getPath();
        String head = this.myPath.getOwner() + ":" + this.myCurrentBranch;
        String base = branch.getRemoteName();
        try {
            return this.myExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.create(this.myServer, forkPath.getOwner(), forkPath.getRepository(), title, description, head, base));
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "github.pull.request.creation.error", GithubBundle.message("pull.request.cannot.create", new Object[0]), e);
            return null;
        }
    }

    public void configureRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(36);
        }
        this.myProgressManager.runProcessWithProgressSynchronously(() -> this.doConfigureRemote(fork), GithubBundle.message("pull.request.create.remote.process.title", new Object[0]), false, this.myProject);
    }

    @NotNull
    public Couple<String> getDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        Couple<String> message;
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(37);
        }
        if ((message = branch.getDefaultMessage()) != null) {
            Couple<String> couple = message;
            if (couple == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(38);
            }
            return couple;
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            Couple<String> couple = this.getSimpleDefaultDescriptionMessage(branch);
            if (couple == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(39);
            }
            return couple;
        }
        Couple couple = (Couple)this.myProgressManager.runProcessWithProgressSynchronously(() -> {
            String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
            try {
                List commits = GitHistoryUtils.collectCommitsMetadata((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{this.myCurrentBranch, targetBranch});
                if (commits == null) {
                    return this.getSimpleDefaultDescriptionMessage(branch);
                }
                VcsCommitMetadata localCommit = (VcsCommitMetadata)commits.get(0);
                VcsCommitMetadata targetCommit = (VcsCommitMetadata)commits.get(1);
                if (localCommit.getParents().contains(targetCommit.getId())) {
                    return GithubUtil.getGithubLikeFormattedDescriptionMessage(localCommit.getFullMessage());
                }
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (ProcessCanceledException e) {
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (VcsException e) {
                GithubNotifications.showWarning(this.myProject, "github.pull.request.cannot.collect.additional.data", GithubBundle.message("cannot.collect.additional.data", new Object[0]), (Exception)((Object)e));
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
        }, GithubBundle.message("pull.request.create.collect.commits.process.title", new Object[0]), true, this.myProject);
        if (couple == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(40);
        }
        return couple;
    }

    @NotNull
    public Couple<String> getSimpleDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(41);
        }
        Couple message = Couple.of((Object)this.myCurrentBranch, (Object)"");
        branch.setDefaultMessage((Couple<String>)message);
        Couple couple = message;
        if (couple == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(42);
        }
        return couple;
    }

    public boolean checkAction(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, GithubBundle.message("pull.request.cannot.create", new Object[0]), GithubBundle.message("pull.request.validation.target.branch.not.selected", new Object[0]));
            return false;
        }
        try {
            info = (DiffInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> (DiffInfo)GithubUtil.runInterruptable(this.myProgressManager.getProgressIndicator(), () -> this.getDiffInfo(branch)), GithubBundle.message("pull.request.create.collect.diff.data.process.title", new Object[0]), false, this.myProject);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "github.pull.request.cannot.collect.diff.data", GithubBundle.message("cannot.collect.diff.data", new Object[0]), e);
            return true;
        }
        if (info == null) {
            return true;
        }
        ForkInfo fork = branch.getForkInfo();
        String localBranchName = "'" + this.myCurrentBranch + "'";
        String targetBranchName = "'" + fork.getRemoteName() + "/" + branch.getRemoteName() + "'";
        if (info.getInfo().getBranchToHeadCommits((Repository)this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, GithubBundle.message("pull.request.create.empty", new Object[0]), GithubBundle.message("pull.request.create.branch.fully.merged", localBranchName, targetBranchName));
        }
        if (!info.getInfo().getHeadToBranchCommits((Repository)this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, GithubBundle.message("pull.request.not.fully.merged.dialog", new Object[0]), GithubBundle.message("pull.request.not.fully.merged.dialog.message", targetBranchName, localBranchName));
        }
        return true;
    }

    public void createPullRequest(final @NotNull BranchInfo branch, final @NotNull String title, final @NotNull String description) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(43);
        }
        if (title == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(44);
        }
        if (description == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(45);
        }
        new Task.Backgroundable(this.myProject, GithubBundle.message("pull.request.create.process.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Pushing current branch");
                indicator.setText(GithubBundle.message("pull.request.push.branch.process.title", new Object[0]));
                GitCommandResult result = GithubCreatePullRequestWorker.this.myGit.push(GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myRemoteName, GithubCreatePullRequestWorker.this.myRemoteUrl, GithubCreatePullRequestWorker.this.myCurrentBranch, true, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GithubNotifications.showError(GithubCreatePullRequestWorker.this.myProject, "github.pull.request.push.failed", GithubBundle.message("pull.request.cannot.create", new Object[0]), GithubBundle.message("pull.request.push.failed", result.getErrorOutputAsHtmlString()));
                    return;
                }
                LOG.info("Creating pull request");
                indicator.setText(GithubBundle.message("pull.request.create.process.title", new Object[0]));
                GithubPullRequestDetailed request = GithubCreatePullRequestWorker.this.doCreatePullRequest(indicator, branch, title, description);
                if (request == null) {
                    return;
                }
                GithubNotifications.showInfoURL(GithubCreatePullRequestWorker.this.myProject, "github.pull.request.created", GithubBundle.message("pull.request.successfully.created", new Object[0]), GithubBundle.message("pull.request.num", request.getNumber()), request.getHtmlUrl());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private List<GHRepositoryPath> getAvailableForks(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(46);
        }
        try {
            List<GithubRepo> forks = GithubApiPagesLoader.loadAll(this.myExecutor, indicator, GithubApiRequests.Repos.Forks.pages(this.myServer, this.mySource.getOwner(), this.mySource.getRepository()));
            List forkPaths = ContainerUtil.map(forks, GithubRepoBasic::getFullPath);
            if (!forkPaths.contains(this.mySource)) {
                return ContainerUtil.append((List)forkPaths, (Object[])new GHRepositoryPath[]{this.mySource});
            }
            return forkPaths;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "github.pull.request.cannot.load.forks", GithubBundle.message("pull.request.cannot.load.forks", new Object[0]), e);
            return null;
        }
    }

    public void showDiffDialog(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, GithubBundle.message("pull.request.cannot.show.diff", new Object[0]), "");
            return;
        }
        try {
            info = (DiffInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> (DiffInfo)GithubUtil.runInterruptable(this.myProgressManager.getProgressIndicator(), () -> this.getDiffInfo(branch)), GithubBundle.message("pull.request.create.collect.diff.data.process.title", new Object[0]), true, this.myProject);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "github.pull.request.cannot.collect.diff.data", GithubBundle.message("cannot.collect.diff.data", new Object[0]), e);
            return;
        }
        if (info == null) {
            GithubNotifications.showErrorDialog(this.myProject, GithubBundle.message("pull.request.cannot.show.diff", new Object[0]), GithubBundle.message("cannot.collect.diff.data", new Object[0]));
            return;
        }
        CompareBranchesDialog dialog2 = new CompareBranchesDialog((CompareBranchesHelper)new GitCompareBranchesHelper(this.myProject), info.getTo(), info.getFrom(), info.getInfo(), (Repository)this.myGitRepository, true);
        dialog2.show();
    }

    @Nullable
    public ForkInfo showTargetDialog() {
        if (this.myAvailableForks == null) {
            try {
                this.myAvailableForks = (List)this.myProgressManager.runProcessWithProgressSynchronously(() -> this.getAvailableForks(this.myProgressManager.getProgressIndicator()), this.myCurrentBranch, false, this.myProject);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        Convertor getForkPath = user -> (ForkInfo)this.myProgressManager.runProcessWithProgressSynchronously(() -> this.findRepositoryByUser(this.myProgressManager.getProgressIndicator(), (String)user), GithubBundle.message("accessing.github", new Object[0]), false, this.myProject);
        GithubSelectForkDialog dialog2 = new GithubSelectForkDialog(this.myProject, this.myAvailableForks, (Convertor<? super String, ? extends ForkInfo>)getForkPath);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        return dialog2.getPath();
    }

    @Nullable
    private ForkInfo findRepositoryByUser(@NotNull ProgressIndicator indicator, @NotNull String user) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(47);
        }
        if (user == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(48);
        }
        for (ForkInfo fork2 : this.myForks) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)user, (CharSequence)fork2.getPath().getOwner())) continue;
            return fork2;
        }
        try {
            GithubRepoDetailed target = this.myExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, user, this.mySource.getRepository()));
            GithubRepo repo = target != null && target.getSource() != null && StringUtil.equals((CharSequence)target.getSource().getUserName(), (CharSequence)this.mySource.getOwner()) ? target : GithubApiPagesLoader.find(this.myExecutor, indicator, GithubApiRequests.Repos.Forks.pages(this.myServer, this.mySource.getOwner(), this.mySource.getRepository()), fork -> StringUtil.equalsIgnoreCase((CharSequence)fork.getUserName(), (CharSequence)user));
            if (repo == null) {
                return null;
            }
            return this.doAddFork(repo, indicator);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "github.pull.request.cannot.find.repo", GithubBundle.message("cannot.find.repository", new Object[0]), e);
            return null;
        }
    }

    @Nullable
    public static GithubCreatePullRequestWorker create(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server) {
        if (project == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(49);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(50);
        }
        if (remote == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(51);
        }
        if (remoteUrl == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(52);
        }
        if (executor == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(53);
        }
        if (server == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(54);
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        return (GithubCreatePullRequestWorker)progressManager.runProcessWithProgressSynchronously(() -> {
            Git git = (Git)ApplicationManager.getApplication().getService(Git.class);
            GHRepositoryPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
            if (path == null) {
                GithubNotifications.showError(project, "github.pull.request.cannot.process.remote", GithubBundle.message("pull.request.cannot.create", new Object[0]), GithubBundle.message("cannot.process.remote", remoteUrl));
                return null;
            }
            GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
            if (currentBranch == null) {
                GithubNotifications.showError(project, "github.pull.request.no.current.branch", GithubBundle.message("pull.request.cannot.create", new Object[0]), GithubBundle.message("pull.request.create.error.no.current.branch", new Object[0]));
                return null;
            }
            GithubCreatePullRequestWorker worker = new GithubCreatePullRequestWorker(project, git, gitRepository, executor, server, GithubGitHelper.getInstance(), progressManager, path, remote.getName(), remoteUrl, currentBranch.getName());
            try {
                worker.initForks(progressManager.getProgressIndicator());
            }
            catch (IOException e) {
                GithubNotifications.showError(project, "github.pull.request.creation.error", GithubBundle.message("pull.request.cannot.create", new Object[0]), e);
                return null;
            }
            return worker;
        }, GithubBundle.message("pull.request.loading.data", new Object[0]), true, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 3: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressManager";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 9: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fork";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getForks";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBranches";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDescriptionMessage";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleDefaultDescriptionMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initForks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doConfigureRemote";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doAddFork";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromGit";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromGithub";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadBranches";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doLoadDefaultBranch";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "launchFetchRemote";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "launchLoadDiffInfo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDiffInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doFetchRemote";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doLoadDiffInfo";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePullRequest";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureRemote";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDescriptionMessage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleDefaultDescriptionMessage";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createPullRequest";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableForks";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findRepositoryByUser";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MasterFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final Object LOCK;
        private boolean myDone;
        @Nullable
        private List<SlaveFutureTask> mySlaves;

        public MasterFutureTask(@NotNull Callable<T> callable) {
            if (callable == null) {
                MasterFutureTask.$$$reportNull$$$0(0);
            }
            super(callable);
            this.LOCK = new Object();
            this.myDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSlave(@NotNull SlaveFutureTask slave) {
            if (slave == null) {
                MasterFutureTask.$$$reportNull$$$0(1);
            }
            if (this.isDone()) {
                return false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myDone) {
                    return false;
                }
                if (this.mySlaves == null) {
                    this.mySlaves = new ArrayList<SlaveFutureTask>();
                }
                this.mySlaves.add(slave);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            Object object = this.LOCK;
            synchronized (object) {
                this.myDone = true;
                if (this.mySlaves != null) {
                    for (SlaveFutureTask slave : this.mySlaves) {
                        this.runSlave(slave);
                    }
                    this.mySlaves = null;
                }
            }
        }

        protected void runSlave(@NotNull SlaveFutureTask slave) {
            if (slave == null) {
                MasterFutureTask.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)slave);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$MasterFutureTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSlave";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runSlave";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SlaveFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final MasterFutureTask myMaster;

        public SlaveFutureTask(@NotNull MasterFutureTask master, @NotNull Callable<T> callable) {
            if (master == null) {
                SlaveFutureTask.$$$reportNull$$$0(0);
            }
            if (callable == null) {
                SlaveFutureTask.$$$reportNull$$$0(1);
            }
            super(callable);
            this.myMaster = master;
        }

        @Override
        public void run() {
            if (this.myMaster.isDone()) {
                super.run();
            } else if (!this.myMaster.addSlave(this)) {
                super.run();
            }
        }

        public T safeGet() {
            try {
                return (T)super.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "master";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$SlaveFutureTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DiffInfo {
        @NotNull
        private final CommitCompareInfo myInfo;
        @NotNull
        private final String myFrom;
        @NotNull
        private final String myTo;

        private DiffInfo(@NotNull CommitCompareInfo info, @NotNull String from, @NotNull String to) {
            if (info == null) {
                DiffInfo.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DiffInfo.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DiffInfo.$$$reportNull$$$0(2);
            }
            this.myInfo = info;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public CommitCompareInfo getInfo() {
            CommitCompareInfo commitCompareInfo = this.myInfo;
            if (commitCompareInfo == null) {
                DiffInfo.$$$reportNull$$$0(3);
            }
            return commitCompareInfo;
        }

        @NotNull
        public String getFrom() {
            String string = this.myFrom;
            if (string == null) {
                DiffInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getTo() {
            String string = this.myTo;
            if (string == null) {
                DiffInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrom";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BranchInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final ForkInfo myForkInfo;
        @NotNull
        private final String myRemoteName;
        @Nullable
        private SlaveFutureTask<DiffInfo> myDiffInfoTask;
        @Nullable
        private Couple<String> myDefaultMessage;

        public BranchInfo(@NotNull String remoteName, @NotNull ForkInfo fork) {
            if (remoteName == null) {
                BranchInfo.$$$reportNull$$$0(0);
            }
            if (fork == null) {
                BranchInfo.$$$reportNull$$$0(1);
            }
            this.LOCK = new Object();
            this.myRemoteName = remoteName;
            this.myForkInfo = fork;
        }

        @NotNull
        public ForkInfo getForkInfo() {
            ForkInfo forkInfo = this.myForkInfo;
            if (forkInfo == null) {
                BranchInfo.$$$reportNull$$$0(2);
            }
            return forkInfo;
        }

        @NotNull
        public String getRemoteName() {
            String string = this.myRemoteName;
            if (string == null) {
                BranchInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public SlaveFutureTask<DiffInfo> getDiffInfoTask() {
            return this.myDiffInfoTask;
        }

        public void setDiffInfoTask(@NotNull SlaveFutureTask<DiffInfo> diffInfoTask) {
            if (diffInfoTask == null) {
                BranchInfo.$$$reportNull$$$0(4);
            }
            this.myDiffInfoTask = diffInfoTask;
        }

        @Nullable
        public Couple<String> getDefaultMessage() {
            return this.myDefaultMessage;
        }

        public void setDefaultMessage(@NotNull Couple<String> message) {
            if (message == null) {
                BranchInfo.$$$reportNull$$$0(5);
            }
            this.myDefaultMessage = message;
        }

        public String toString() {
            return this.myRemoteName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fork";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffInfoTask";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForkInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setDiffInfoTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ForkInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final GHRepositoryPath myPath;
        @NotNull
        private final String myDefaultBranch;
        @NotNull
        private final List<BranchInfo> myBranches;
        @Nullable
        private String myRemoteName;
        private boolean myProposedToCreateRemote;
        @Nullable
        private MasterFutureTask<Void> myFetchTask;

        public ForkInfo(@NotNull GHRepositoryPath path, @NotNull List<String> branches, @Nullable String defaultBranch) {
            if (path == null) {
                ForkInfo.$$$reportNull$$$0(0);
            }
            if (branches == null) {
                ForkInfo.$$$reportNull$$$0(1);
            }
            this.LOCK = new Object();
            this.myPath = path;
            this.myDefaultBranch = defaultBranch == null ? "master" : defaultBranch;
            this.myBranches = new ArrayList<BranchInfo>();
            for (String branchName : branches) {
                this.myBranches.add(new BranchInfo(branchName, this));
            }
        }

        @NotNull
        public GHRepositoryPath getPath() {
            GHRepositoryPath gHRepositoryPath = this.myPath;
            if (gHRepositoryPath == null) {
                ForkInfo.$$$reportNull$$$0(2);
            }
            return gHRepositoryPath;
        }

        @Nullable
        public String getRemoteName() {
            return this.myRemoteName;
        }

        @NotNull
        public String getDefaultBranch() {
            String string = this.myDefaultBranch;
            if (string == null) {
                ForkInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<BranchInfo> getBranches() {
            List<BranchInfo> list2 = this.myBranches;
            if (list2 == null) {
                ForkInfo.$$$reportNull$$$0(4);
            }
            return list2;
        }

        public void setRemoteName(@NotNull String remoteName) {
            if (remoteName == null) {
                ForkInfo.$$$reportNull$$$0(5);
            }
            this.myRemoteName = remoteName;
        }

        public boolean isProposedToCreateRemote() {
            return this.myProposedToCreateRemote;
        }

        public void setProposedToCreateRemote(boolean proposedToCreateRemote) {
            this.myProposedToCreateRemote = proposedToCreateRemote;
        }

        @Nullable
        public MasterFutureTask<Void> getFetchTask() {
            return this.myFetchTask;
        }

        public void setFetchTask(@NotNull MasterFutureTask<Void> fetchTask) {
            if (fetchTask == null) {
                ForkInfo.$$$reportNull$$$0(6);
            }
            this.myFetchTask = fetchTask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkInfo info = (ForkInfo)o;
            return this.myPath.equals(info.myPath);
        }

        public int hashCode() {
            return this.myPath.hashCode();
        }

        public String toString() {
            return this.myPath.getOwner() + ":" + this.myPath.getRepository();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branches";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetchTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultBranch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setRemoteName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setFetchTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

