/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructorSymbol callee = expression2.getSymbol();
                IrClass parent2 = IrUtilsKt.getParentAsClass(callee.getOwner());
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                int classTypeParametersCount = expression2.getTypeArgumentsCount() - expression2.getConstructorTypeArgumentsCount();
                IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrConstructorSymbol)newCallee.getSymbol(), classTypeParametersCount, expression2.getOrigin());
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(newCall, expression2, 0, 2, null);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructor classConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                if (!IrUtilsKt.getParentAsClass(classConstructor).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter(classConstructor);
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)newCallee.getSymbol(), expression2.getTypeArgumentsCount());
                int n = 0;
                boolean bl = false;
                IrDelegatingConstructorCallImpl $this$apply = irDelegatingConstructorCallImpl;
                boolean bl2 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$apply, expression2, 0, 2, null);
                IrDelegatingConstructorCallImpl newCall = irDelegatingConstructorCallImpl;
                newCall.putValueArgument(0, dispatchReceiver);
                int n2 = 1;
                n = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n2 <= n) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrConstructor irConstructor;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrSymbol irSymbol = expression2.getSymbol();
                if (!(irSymbol instanceof IrConstructorSymbol)) {
                    irSymbol = null;
                }
                IrConstructorSymbol irConstructorSymbol = (IrConstructorSymbol)irSymbol;
                if (irConstructorSymbol == null) {
                    return expression2;
                }
                IrConstructorSymbol callee = irConstructorSymbol;
                IrDeclarationParent irDeclarationParent = ((IrConstructor)callee.getOwner()).getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass2 = (IrClass)irDeclarationParent;
                if (irClass2 == null) {
                    return expression2;
                }
                IrClass parent2 = irClass2;
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol != null) {
                    IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
                    boolean bl2 = false;
                    bl = false;
                    IrFunctionSymbol reflectionTarget = irFunctionSymbol2;
                    boolean bl3 = false;
                    irConstructor = reflectionTarget instanceof IrConstructorSymbol ? this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter((IrConstructor)((IrConstructorSymbol)reflectionTarget).getOwner()) : null;
                } else {
                    irConstructor = null;
                }
                IrConstructor newReflectionTarget = irConstructor;
                IrFunctionReference irFunctionReference = expression2;
                bl = false;
                boolean bl4 = false;
                IrFunctionReference $this$run = irFunctionReference;
                boolean bl5 = false;
                IrConstructor irConstructor2 = newReflectionTarget;
                IrFunctionReferenceImpl newReference = new IrFunctionReferenceImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), newCallee.getSymbol(), $this$run.getTypeArgumentsCount(), irConstructor2 != null ? (IrConstructorSymbol)irConstructor2.getSymbol() : null, $this$run.getOrigin());
                irFunctionReference = newReference;
                bl = false;
                bl4 = false;
                IrFunctionReference it = irFunctionReference;
                boolean bl6 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(it, expression2, 0, 2, null);
                ((IrMemberAccessExpressionBase)((Object)it)).setDispatchReceiver(expression2.getDispatchReceiver());
                ((IrMemberAccessExpressionBase)((Object)it)).setExtensionReceiver(expression2.getExtensionReceiver());
                int n = 0;
                int n2 = expression2.getValueArgumentsCount();
                while (n < n2) {
                    void v;
                    ((IrCallWithIndexedArgumentsBase)((Object)it)).putValueArgument((int)v, expression2.getValueArgument((int)v));
                    ++v;
                }
                return newReference;
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassConstructorCallsLowering(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

