/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.actions;

import com.intellij.filePrediction.FilePredictionBundle;
import com.intellij.filePrediction.FilePredictionNotifications;
import com.intellij.filePrediction.actions.FileCandidatePresentation;
import com.intellij.filePrediction.actions.FilePredictionCustomCandidateProvider;
import com.intellij.filePrediction.actions.FilePredictionNextCandidatesAction;
import com.intellij.filePrediction.candidates.CompositeCandidateProvider;
import com.intellij.filePrediction.candidates.FilePredictionCandidateProvider;
import com.intellij.filePrediction.candidates.FilePredictionNeighborFilesProvider;
import com.intellij.filePrediction.candidates.FilePredictionReferenceProvider;
import com.intellij.filePrediction.predictor.FilePredictionCandidate;
import com.intellij.filePrediction.predictor.FileUsagePredictor;
import com.intellij.filePrediction.predictor.FileUsagePredictorProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/filePrediction/actions/FilePredictionNextCandidatesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "calculatePresentation", "Lcom/intellij/filePrediction/actions/FileCandidatePresentation;", "project", "Lcom/intellij/openapi/project/Project;", "candidate", "Lcom/intellij/filePrediction/predictor/FilePredictionCandidate;", "findSelectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCandidatesProvider", "Lcom/intellij/filePrediction/candidates/FilePredictionCandidateProvider;", "roundProbability", "", "showCandidates", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "candidates", "", "intellij.filePrediction"})
public final class FilePredictionNextCandidatesAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            String message = FilePredictionBundle.INSTANCE.message("file.prediction.predict.next.files.project.not.defined", new Object[0]);
            FilePredictionNotifications.INSTANCE.showWarning(null, message);
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        String title = FilePredictionBundle.INSTANCE.message("file.prediction.predict.next.files.process.title", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project, file, e, title, project, title, false){
            final /* synthetic */ FilePredictionNextCandidatesAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                FileUsagePredictor predictor = FileUsagePredictorProvider.INSTANCE.getFileUsagePredictor(FilePredictionNextCandidatesAction.access$getCandidatesProvider(this.this$0));
                int limit = Registry.get((String)"filePrediction.action.calculate.candidates").asInteger();
                PsiFile psiFile = this.$file;
                List<FilePredictionCandidate> candidates = predictor.predictNextFile(this.$project, (VirtualFile)(psiFile != null ? psiFile.getVirtualFile() : null), limit);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, candidates){
                    final /* synthetic */ actionPerformed.1 this$0;
                    final /* synthetic */ List $candidates;

                    public final void run() {
                        int toShow = Registry.get((String)"filePrediction.action.show.candidates").asInteger();
                        FilePredictionNextCandidatesAction filePredictionNextCandidatesAction = this.this$0.this$0;
                        Project project = this.this$0.$project;
                        DataContext dataContext = this.this$0.$e.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
                        FilePredictionNextCandidatesAction.access$showCandidates(filePredictionNextCandidatesAction, project, dataContext, CollectionsKt.take((Iterable)this.$candidates, (int)toShow));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$candidates = list;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$file = $captured_local_variable$2;
                this.$e = $captured_local_variable$3;
                this.$title = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        });
    }

    private final FilePredictionCandidateProvider getCandidatesProvider() {
        boolean useAllCandidates = Registry.get((String)"filePrediction.action.use.all.candidates").asBoolean();
        if (useAllCandidates) {
            return new CompositeCandidateProvider();
        }
        ArrayList providers = CollectionsKt.arrayListOf((Object[])new FilePredictionCandidateProvider[]{new FilePredictionReferenceProvider(), new FilePredictionNeighborFilesProvider()});
        return new FilePredictionCustomCandidateProvider(providers);
    }

    /*
     * WARNING - void declaration
     */
    private final void showCandidates(Project project, DataContext context, List<FilePredictionCandidate> candidates) {
        void $this$mapTo$iv$iv;
        String title = FilePredictionBundle.INSTANCE.message("file.prediction.predict.next.files.popup.title", new Object[0]);
        Iterable $this$map$iv = candidates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePredictionCandidate filePredictionCandidate = (FilePredictionCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileCandidatePresentation fileCandidatePresentation = this.calculatePresentation(project, (FilePredictionCandidate)it);
            collection.add(fileCandidatePresentation);
        }
        List presentation = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<FileCandidatePresentation>(this, project, title, presentation, title, presentation){
            final /* synthetic */ FilePredictionNextCandidatesAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ List $presentation;

            @NotNull
            public String getTextFor(@Nullable FileCandidatePresentation value) {
                Object object;
                block3: {
                    block2: {
                        object = value;
                        if (object == null || (object = ((FileCandidatePresentation)object).getPresentableName()) == null) break block2;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        String string = StringUtil.shortenPathWithEllipsis((String)it, (int)50);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenPathWithEllipsis(it, 50)");
                        String shortPath = string;
                        String string2 = shortPath + " (" + FilePredictionNextCandidatesAction.access$roundProbability(this.this$0, value.getOriginal()) + ')';
                        object = string2;
                        if (string2 != null) break block3;
                    }
                    String string = super.getTextFor((Object)value);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.getTextFor(value)");
                }
                return object;
            }

            @Nullable
            public Icon getIconFor(@Nullable FileCandidatePresentation value) {
                Object object = value;
                if (object == null || (object = ((FileCandidatePresentation)object).getIcon()) == null) {
                    object = super.getIconFor((Object)value);
                }
                return object;
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull FileCandidatePresentation candidate, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                return this.doFinalStep(new Runnable(this, candidate){
                    final /* synthetic */ showCandidates.requestsCollectionPopup.1 this$0;
                    final /* synthetic */ FileCandidatePresentation $candidate;

                    public final void run() {
                        block0: {
                            VirtualFile virtualFile = this.$candidate.getFile();
                            if (virtualFile == null) break block0;
                            VirtualFile virtualFile2 = virtualFile;
                            boolean bl = false;
                            boolean bl2 = false;
                            VirtualFile it = virtualFile2;
                            boolean bl3 = false;
                            FileEditorManager.getInstance((Project)this.this$0.$project).openFile(it, true);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$candidate = fileCandidatePresentation;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$presentation = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026     }\n        }\n      })");
        ListPopup requestsCollectionPopup2 = listPopup;
        requestsCollectionPopup2.showInBestPositionFor(context);
    }

    private final FileCandidatePresentation calculatePresentation(Project project, FilePredictionCandidate candidate) {
        PsiFile psiFile;
        VirtualFile file = this.findSelectedFile(candidate);
        if (file == null) {
            return new FileCandidatePresentation(file, null, candidate.getPath(), candidate);
        }
        PsiFile psiFile2 = psiFile = PsiManager.getInstance((Project)project).findFile(file);
        Icon icon = psiFile2 != null ? psiFile2.getIcon(1) : null;
        String string = file.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.presentableName");
        return new FileCandidatePresentation(file, icon, string, candidate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final double roundProbability(FilePredictionCandidate candidate) {
        double probability;
        Double d = candidate.getProbability();
        if (d == null) return -1.0;
        double d2 = probability = d.doubleValue();
        boolean bl = false;
        double d3 = d2;
        boolean bl2 = false;
        if (Double.isInfinite(d3)) return -1.0;
        d3 = d2;
        bl2 = false;
        if (Double.isNaN(d3)) return -1.0;
        boolean bl3 = true;
        if (!bl3) {
            return -1.0;
        }
        d2 = probability * (double)100;
        return Math.rint(d2) / (double)100;
    }

    private final VirtualFile findSelectedFile(FilePredictionCandidate candidate) {
        if (candidate != null) {
            String string = VfsUtilCore.pathToUrl((String)candidate.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(candidate.path)");
            String url = string;
            return VirtualFileManager.getInstance().findFileByUrl(url);
        }
        return null;
    }

    public static final /* synthetic */ FilePredictionCandidateProvider access$getCandidatesProvider(FilePredictionNextCandidatesAction $this) {
        return $this.getCandidatesProvider();
    }

    public static final /* synthetic */ void access$showCandidates(FilePredictionNextCandidatesAction $this, Project project, DataContext context, List candidates) {
        $this.showCandidates(project, context, candidates);
    }

    public static final /* synthetic */ double access$roundProbability(FilePredictionNextCandidatesAction $this, FilePredictionCandidate candidate) {
        return $this.roundProbability(candidate);
    }
}

