/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.KeyStroke;
import org.fest.swing.keystroke.KeyStrokeMapCollection;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.KeyStrokeMappingProviderPicker;
import org.fest.swing.util.Platform;
import org.fest.util.VisibleForTesting;

public class KeyStrokeMap {
    private static KeyStrokeMapCollection maps = new KeyStrokeMapCollection();

    public static void reloadFromSystemSettings() {
        KeyStrokeMappingProviderPicker picker = new KeyStrokeMappingProviderPicker();
        maps.clear();
        KeyStrokeMap.addKeyStrokesFrom(picker.providerFor(Platform.osFamily(), Locale.getDefault()));
    }

    @VisibleForTesting
    static void updateKeyStrokeMapCollection(@Nonnull KeyStrokeMapCollection c) {
        maps = c;
    }

    public static void addKeyStrokesFrom(@Nonnull KeyStrokeMappingProvider provider) {
        for (KeyStrokeMapping entry : provider.keyStrokeMappings()) {
            KeyStrokeMap.add(Character.valueOf(entry.character()), entry.keyStroke());
        }
    }

    private static void add(@Nonnull Character character, @Nonnull KeyStroke keyStroke) {
        maps.add(character, keyStroke);
    }

    public static void clearKeyStrokes() {
        maps.clear();
    }

    public static boolean hasKeyStrokes() {
        return !maps.isEmpty();
    }

    @Nullable
    public static KeyStroke keyStrokeFor(char character) {
        return maps.keyStrokeFor(character);
    }

    public static char charFor(@Nonnull KeyStroke keyStroke) {
        Character character = maps.charFor(keyStroke);
        if (character == null) {
            character = KeyStrokeMap.charWithoutModifiersButShift(keyStroke);
        }
        if (character == null) {
            return '\uffff';
        }
        return character.charValue();
    }

    @Nullable
    private static Character charWithoutModifiersButShift(@Nonnull KeyStroke keyStroke) {
        int mask = keyStroke.getModifiers() & 0xFFFFFFFE;
        return maps.charFor(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), mask));
    }

    private KeyStrokeMap() {
    }

    static {
        KeyStrokeMap.reloadFromSystemSettings();
    }
}

