/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.fixture.AbstractJPopupMenuInvokerFixture;
import org.fest.swing.fixture.ItemGroupFixture;
import org.fest.swing.fixture.JListItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.util.Range;

public class JListFixture
extends AbstractJPopupMenuInvokerFixture<JListFixture, JList, JListDriver>
implements ItemGroupFixture<JListFixture> {
    public JListFixture(@Nonnull Robot robot, @Nullable String listName) {
        super(JListFixture.class, robot, listName, JList.class);
    }

    public JListFixture(@Nonnull Robot robot, @Nonnull JList target) {
        super(JListFixture.class, robot, target);
    }

    @Override
    @Nonnull
    protected JListDriver createDriver(@Nonnull Robot robot) {
        return new JListDriver(robot);
    }

    @Override
    @Nullable
    public String valueAt(int index) {
        return ((JListDriver)this.driver()).value((JList)this.target(), index);
    }

    @Override
    @Nonnull
    public String[] contents() {
        return ((JListDriver)this.driver()).contentsOf((JList)this.target());
    }

    @Nonnull
    public String[] selection() {
        return ((JListDriver)this.driver()).selectionOf((JList)this.target());
    }

    @Nonnull
    public JListItemFixture item(int index) {
        return new JListItemFixture(this, index);
    }

    @Nonnull
    public JListItemFixture item(@Nullable String text) {
        return new JListItemFixture(this, ((JListDriver)this.driver()).indexOf((JList)this.target(), text));
    }

    @Nonnull
    public JListItemFixture item(@Nonnull Pattern pattern) {
        return new JListItemFixture(this, ((JListDriver)this.driver()).indexOf((JList)this.target(), pattern));
    }

    @Override
    @Nonnull
    public JListFixture clearSelection() {
        ((JListDriver)this.driver()).clearSelection((JList)this.target());
        return this;
    }

    @Override
    @Nonnull
    public JListFixture selectItem(int index) {
        ((JListDriver)this.driver()).selectItem((JList)this.target(), index);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture selectItem(@Nullable String text) {
        ((JListDriver)this.driver()).selectItem((JList)this.target(), text);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture selectItem(@Nonnull Pattern pattern) {
        ((JListDriver)this.driver()).selectItem((JList)this.target(), pattern);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture requireSelection(@Nullable String text) {
        ((JListDriver)this.driver()).requireSelection((JList)this.target(), text);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture requireSelection(@Nonnull Pattern pattern) {
        ((JListDriver)this.driver()).requireSelection((JList)this.target(), pattern);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture requireSelection(int index) {
        ((JListDriver)this.driver()).requireSelection((JList)this.target(), index);
        return this;
    }

    @Override
    @Nonnull
    public JListFixture requireNoSelection() {
        ((JListDriver)this.driver()).requireNoSelection((JList)this.target());
        return this;
    }

    @Override
    @Nonnull
    public JListFixture requireItemCount(int expected) {
        ((JListDriver)this.driver()).requireItemCount((JList)this.target(), expected);
        return this;
    }

    @Nonnull
    public JListFixture selectItems(@Nonnull Range.From from, @Nonnull Range.To to) {
        ((JListDriver)this.driver()).selectItems((JList)this.target(), from, to);
        return this;
    }

    @Nonnull
    public JListFixture selectItems(int ... indices) {
        ((JListDriver)this.driver()).selectItems((JList)this.target(), indices);
        return this;
    }

    @Nonnull
    public JListFixture selectItems(String ... items) {
        ((JListDriver)this.driver()).selectItems((JList)this.target(), items);
        return this;
    }

    @Nonnull
    public JListFixture selectItems(Pattern ... patterns) {
        ((JListDriver)this.driver()).selectItems((JList)this.target(), patterns);
        return this;
    }

    @Nonnull
    public JListFixture clickItem(int index) {
        ((JListDriver)this.driver()).clickItem((JList)this.target(), index, MouseButton.LEFT_BUTTON, 1);
        return this;
    }

    public JListFixture clickItem(@Nullable String text) {
        ((JListDriver)this.driver()).clickItem((JList)this.target(), text, MouseButton.LEFT_BUTTON, 1);
        return this;
    }

    @Nonnull
    public JListFixture clickItem(@Nonnull Pattern pattern) {
        ((JListDriver)this.driver()).clickItem((JList)this.target(), pattern, MouseButton.LEFT_BUTTON, 1);
        return this;
    }

    void clickItem(int index, @Nonnull MouseButton button, int times) {
        ((JListDriver)this.driver()).clickItem((JList)this.target(), index, button, times);
    }

    @Nonnull
    public JListFixture requireSelectedItems(int ... indices) {
        ((JListDriver)this.driver()).requireSelectedItems((JList)this.target(), indices);
        return this;
    }

    @Nonnull
    public JListFixture requireSelectedItems(String ... items) {
        ((JListDriver)this.driver()).requireSelectedItems((JList)this.target(), items);
        return this;
    }

    @Nonnull
    public JListFixture requireSelectedItems(@Nonnull Pattern[] patterns) {
        ((JListDriver)this.driver()).requireSelectedItems((JList)this.target(), patterns);
        return this;
    }

    @Nonnull
    public JListFixture drag(int index) {
        ((JListDriver)this.driver()).drag((JList)this.target(), index);
        return this;
    }

    @Nonnull
    public JListFixture drop(int index) {
        ((JListDriver)this.driver()).drop((JList)this.target(), index);
        return this;
    }

    @Nonnull
    public JListFixture drag(@Nullable String text) {
        ((JListDriver)this.driver()).drag((JList)this.target(), text);
        return this;
    }

    @Nonnull
    public JListFixture drop(@Nullable String text) {
        ((JListDriver)this.driver()).drop((JList)this.target(), text);
        return this;
    }

    @Nonnull
    public JListFixture drag(@Nonnull Pattern pattern) {
        ((JListDriver)this.driver()).drag((JList)this.target(), pattern);
        return this;
    }

    @Nonnull
    public JListFixture drop(@Nonnull Pattern pattern) {
        ((JListDriver)this.driver()).drop((JList)this.target(), pattern);
        return this;
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(int index) {
        return new JPopupMenuFixture(this.robot(), ((JListDriver)this.driver()).showPopupMenu((JList)this.target(), index));
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(@Nullable String text) {
        return new JPopupMenuFixture(this.robot(), ((JListDriver)this.driver()).showPopupMenu((JList)this.target(), text));
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(@Nonnull Pattern pattern) {
        return new JPopupMenuFixture(this.robot(), ((JListDriver)this.driver()).showPopupMenu((JList)this.target(), pattern));
    }

    public void replaceCellReader(@Nonnull JListCellReader cellReader) {
        ((JListDriver)this.driver()).replaceCellReader(cellReader);
    }
}

