/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JScrollBar;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.JScrollBarLocationStrategy;

class VerticalJScrollBarLocation
extends JScrollBarLocationStrategy {
    VerticalJScrollBarLocation() {
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    Point thumbLocation(@Nonnull JScrollBar scrollBar, double fraction) {
        int arrow = this.arrow(scrollBar);
        return new Point(arrow / 2, arrow + (int)(fraction * (double)(scrollBar.getHeight() - 2 * arrow)));
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    Point blockLocation(@Nonnull JScrollBar scrollBar, @Nonnull Point unitLocation, int offset) {
        Point p = new Point(unitLocation);
        p.y += offset;
        return p;
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    Point unitLocationToScrollDown(@Nonnull JScrollBar scrollBar) {
        int arrow = this.arrow(scrollBar);
        return new Point(arrow / 2, scrollBar.getHeight() - arrow / 2);
    }

    @Override
    @RunsInCurrentThread
    int arrow(@Nonnull JScrollBar scrollBar) {
        return scrollBar.getWidth();
    }
}

