/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Lists;

final class JTreeAddRootIfInvisibleTask {
    @Nonnull
    @RunsInCurrentThread
    static TreePath addRootIfInvisible(@Nonnull JTree tree, @Nonnull TreePath path) {
        Object root = tree.getModel().getRoot();
        if (tree.isRootVisible() || root == null) {
            return path;
        }
        if (path.getPathCount() > 0 && root == path.getPathComponent(0)) {
            return path;
        }
        Object[] pathAsArray = path.getPath();
        if (pathAsArray == null) {
            return new TreePath(Lists.newArrayList((Object[])new Object[]{root}));
        }
        ArrayList newPath = Lists.newArrayList((Object[])pathAsArray);
        newPath.add(0, root);
        return new TreePath(newPath.toArray());
    }

    private JTreeAddRootIfInvisibleTask() {
    }
}

