/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

public class BasicJComboBoxCellReader
implements JComboBoxCellReader {
    private static final JList REFERENCE_JLIST = BasicJComboBoxCellReader.newJList();
    private final CellRendererReader rendererReader;

    @Nonnull
    private static JList newJList() {
        JList result = GuiActionRunner.execute(new GuiQuery<JList>(){

            @Override
            @Nullable
            protected JList executeInEDT() {
                return new JList();
            }
        });
        return (JList)Preconditions.checkNotNull((Object)result);
    }

    public BasicJComboBoxCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJComboBoxCellReader(@Nonnull CellRendererReader rendererReader) {
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JComboBox comboBox, int index) {
        String value;
        Component c = this.cellRendererComponent(comboBox, index);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(comboBox.getItemAt(index));
    }

    @Nullable
    @RunsInCurrentThread
    private Component cellRendererComponent(@Nonnull JComboBox comboBox, int index) {
        Object item = comboBox.getItemAt(index);
        ListCellRenderer renderer = comboBox.getRenderer();
        return renderer.getListCellRendererComponent(REFERENCE_JLIST, item, index, true, true);
    }
}

