/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.lang.reflect.Field;

public class FieldAccessor<FIELD_TYPE> {
    private volatile FIELD_TYPE myWagonManagerCache;
    private final Class myHostClass;
    private final Object myHost;
    private final String myFieldName;

    public <T> FieldAccessor(Class<? super T> hostClass, T host, String fieldName) {
        this.myHostClass = hostClass;
        this.myHost = host;
        this.myFieldName = fieldName;
    }

    public FIELD_TYPE getField() {
        if (this.myWagonManagerCache == null) {
            Object wagon = this.getFieldValue(this.myHostClass, this.myFieldName, this.myHost);
            this.myWagonManagerCache = wagon;
        }
        return this.myWagonManagerCache;
    }

    private Object getFieldValue(Class c, String fieldName, Object o) {
        try {
            Field f = c.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

