/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendableStorageBackedByResizableMappedFile<Data>
extends ResizeableMappedFile
implements AppendableObjectStorage<Data> {
    private static final ThreadLocal<MyDataIS> ourReadStream = ThreadLocal.withInitial(() -> new MyDataIS());
    private volatile byte[] myAppendBuffer;
    private volatile int myFileLength;
    private volatile int myBufferPosition;
    private static final int ourAppendBufferLength = 4096;
    @NotNull
    private final KeyDescriptor<Data> myDataDescriptor;
    private static final InputStream TOMBSTONE = new InputStream(){

        @Override
        public int read() {
            throw new IllegalStateException("should not happen");
        }
    };

    public AppendableStorageBackedByResizableMappedFile(Path file, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, @NotNull KeyDescriptor<Data> dataDescriptor) {
        if (dataDescriptor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(0);
        }
        super(file, initialSize, lockContext, pageSize, valuesAreBufferAligned);
        this.myDataDescriptor = dataDescriptor;
        this.myFileLength = (int)this.length();
    }

    private void flushKeyStoreBuffer() {
        if (this.myBufferPosition > 0) {
            this.put(this.myFileLength, this.myAppendBuffer, 0, this.myBufferPosition);
            this.myFileLength += this.myBufferPosition;
            this.myBufferPosition = 0;
        }
    }

    @Override
    public void force() {
        this.flushKeyStoreBuffer();
        super.force();
    }

    @Override
    public void close() {
        this.flushKeyStoreBuffer();
        super.close();
        ourReadStream.remove();
    }

    @Override
    public Data read(int addr) throws IOException {
        if (this.myFileLength <= addr) {
            if (this.myAppendBuffer == null) {
                throw new NoDataException("requested address points to un-existed data");
            }
            int bufferOffset = addr - this.myFileLength;
            if (bufferOffset > this.myBufferPosition) {
                throw new NoDataException("requested address points to un-existed data");
            }
            return (Data)this.myDataDescriptor.read(new DataInputStream(new UnsyncByteArrayInputStream(this.myAppendBuffer, bufferOffset, this.myBufferPosition)));
        }
        MyDataIS rs = ourReadStream.get();
        rs.setup(this, addr, this.myFileLength);
        return (Data)this.myDataDescriptor.read(rs);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processAll(@NotNull Processor<? super Data> processor) throws IOException {
        boolean bl;
        if (processor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(1);
        }
        assert (!this.isDirty());
        if (this.myFileLength == 0) {
            return true;
        }
        DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(Files.newInputStream(this.getPagedFileStorage().getFile(), new OpenOption[0]), this.myFileLength){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, 32768));
        try {
            Object key;
            while (processor.process(key = this.myDataDescriptor.read(keysStream))) {
            }
            bl = false;
        }
        catch (EOFException eOFException) {
            boolean bl2 = true;
            keysStream.close();
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                keysStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        keysStream.close();
        return bl;
    }

    @Override
    public int getCurrentLength() {
        return this.myBufferPosition + this.myFileLength;
    }

    @Override
    public int append(Data value) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.myDataDescriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
        } else {
            if (size > 4096 - this.myBufferPosition) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new byte[4096];
            }
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }
        return currentLength;
    }

    @Override
    public boolean checkBytesAreTheSame(int addr, Data value) throws IOException {
        boolean[] sameValue = new boolean[1];
        OutputStream comparer = this.buildOldComparerStream(addr, sameValue);
        DataOutputStream out = new DataOutputStream(comparer);
        this.myDataDescriptor.save(out, value);
        comparer.close();
        return sameValue[0];
    }

    @Override
    public void lockRead() {
        this.getPagedFileStorage().lockRead();
    }

    @Override
    public void unlockRead() {
        this.getPagedFileStorage().unlockRead();
    }

    @Override
    public void lockWrite() {
        this.getPagedFileStorage().lockWrite();
    }

    @Override
    public void unlockWrite() {
        this.getPagedFileStorage().unlockWrite();
    }

    @NotNull
    private OutputStream buildOldComparerStream(final int addr, final boolean[] sameValue) {
        final PagedFileStorage storage = this.getPagedFileStorage();
        OutputStream comparer = this.myFileLength <= addr ? new OutputStream(){
            int address;
            boolean same;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
                this.same = true;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myBufferPosition && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer[this.address++] == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        } : new OutputStream(){
            int base;
            int address;
            boolean same;
            ByteBuffer buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage.getOffsetInPage(addr);
                this.same = true;
                this.buffer = storage.getByteBuffer(addr, false).getCachedBuffer();
                this.myPageSize = storage.getPageSize();
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer = storage.getByteBuffer(this.base, false).getCachedBuffer();
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++) == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        };
        OutputStream outputStream = comparer;
        if (outputStream == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(2);
        }
        return outputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOldComparerStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        MyBufferedIS() {
            super(TOMBSTONE, 512);
        }

        void setup(ResizeableMappedFile in, long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            this.in = new MappedFileInputStream(in, pos, limit);
        }
    }

    private static final class MyDataIS
    extends DataInputStream {
        private MyDataIS() {
            super(new MyBufferedIS());
        }

        void setup(ResizeableMappedFile is, long pos, long limit) {
            ((MyBufferedIS)this.in).setup(is, pos, limit);
        }
    }
}

