/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOUtil {
    public static final boolean BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER = Boolean.parseBoolean(System.getProperty("idea.bytebuffers.use.native.byte.order", "true"));
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte @NotNull [] create() {
            byte[] byArray = IOUtil.allocReadWriteUTFBuffer();
            if (byArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return byArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil$1", "create"));
        }
    };

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, CharsetToolkit.UTF_16BE_CHARSET);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static void writeString(@Nullable String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage);
    }

    public static byte @NotNull [] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull String value) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        if ((len = value.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            IOUtil.writeString(value, storage);
        }
    }

    public static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull Path file) {
        List files;
        if (file == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        String baseName = file.getFileName().toString();
        Path parentFile = file.getParent();
        if (parentFile == null) {
            return true;
        }
        try (Stream<Path> stream = Files.list(parentFile);){
            files = stream.filter(it -> it.getFileName().toString().startsWith(baseName)).collect(Collectors.toList());
        }
        catch (NoSuchFileException ignore) {
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
        boolean ok = true;
        for (Path f : files) {
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException ignore) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file) {
        if (file == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        String baseName = file.getName();
        File parentFile = file.getParentFile();
        File[] files = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files != null) {
            for (File f : files) {
                ok &= FileUtilRt.delete(f);
            }
        }
        return ok;
    }

    public static void syncStream(@NotNull OutputStream stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        stream.flush();
        try {
            Object o;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while (stream instanceof FilterOutputStream && (o = outField.get(stream)) instanceof OutputStream) {
                stream = (OutputStream)o;
            }
            if (stream instanceof FileOutputStream) {
                ((FileOutputStream)stream).getFD().sync();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Path file) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        if (file == null) {
            IOUtil.$$$reportNull$$$0(18);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, file.toFile());
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            IOUtil.$$$reportNull$$$0(20);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(21);
        }
        if (cleanupCallback == null) {
            IOUtil.$$$reportNull$$$0(22);
        }
        try {
            return factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list) throws IOException {
        if (out == null) {
            IOUtil.$$$reportNull$$$0(23);
        }
        if (list == null) {
            IOUtil.$$$reportNull$$$0(24);
        }
        DataInputOutputUtil.writeINT(out, list.size());
        for (String s : list) {
            IOUtil.writeUTF(out, s);
        }
    }

    @NotNull
    public static <C extends Collection<String>> C readStringCollection(@NotNull DataInput in, @NotNull IntFunction<C> generator) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(25);
        }
        if (generator == null) {
            IOUtil.$$$reportNull$$$0(26);
        }
        int size = DataInputOutputUtil.readINT(in);
        Collection strings = (Collection)generator.apply(size);
        for (int i = 0; i < size; ++i) {
            strings.add(IOUtil.readUTF(in));
        }
        Collection collection = strings;
        if (collection == null) {
            IOUtil.$$$reportNull$$$0(27);
        }
        return (C)collection;
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(28);
        }
        return IOUtil.readStringCollection(in, ArrayList::new);
    }

    public static void closeSafe(@NotNull Logger log, Closeable ... closeables) {
        if (log == null) {
            IOUtil.$$$reportNull$$$0(29);
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryComputable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupCallback";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFTruncated";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFFast";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFast";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAscii";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllFilesStartingWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "syncStream";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openCleanOrResetBroken";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readStringCollection";
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "closeSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

