/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import training.keymap.KeymapUtil;
import training.learn.CourseManager;
import training.learn.interfaces.Lesson;
import training.ui.MessageFactory;
import training.ui.MessagePart;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\nJ\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltraining/ui/MessageFactory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "convert", "", "Ltraining/ui/MessagePart;", "text", "", "element", "Lorg/jdom/Element;", "setLinksHandlers", "", "project", "Lcom/intellij/openapi/project/Project;", "messageParts", "intellij.featuresTrainer"})
public final class MessageFactory {
    private static final Logger LOG;
    public static final MessageFactory INSTANCE;

    public final void setLinksHandlers(@NotNull Project project, @NotNull List<MessagePart> messageParts) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        for (MessagePart message : messageParts) {
            if (message.getType() != MessagePart.MessageType.LINK || message.getRunnable() != null) continue;
            message.setRunnable(new Runnable(message, project){
                final /* synthetic */ MessagePart $message;
                final /* synthetic */ Project $project;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void run() {
                    String link;
                    block6: {
                        Lesson lesson;
                        block5: {
                            link = this.$message.getLink();
                            if (link == null) break block5;
                            CharSequence charSequence = link;
                            boolean bl = false;
                            if (!(charSequence.length() == 0)) break block6;
                        }
                        if ((lesson = CourseManager.Companion.getInstance().findLesson(this.$message.getText())) == null) return;
                        try {
                            CourseManager.Companion.getInstance().openLesson(this.$project, lesson);
                            return;
                        }
                        catch (Exception e) {
                            MessageFactory.access$getLOG$p(MessageFactory.INSTANCE).warn((Throwable)e);
                        }
                        return;
                    }
                    try {
                        UtilsKt.openLinkInBrowser(link);
                        return;
                    }
                    catch (Exception e) {
                        MessageFactory.access$getLOG$p(MessageFactory.INSTANCE).warn((Throwable)e);
                    }
                }
                {
                    this.$message = messagePart;
                    this.$project = project;
                }
            });
        }
    }

    @NotNull
    public final List<MessagePart> convert(@Language(value="HTML") @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String wrappedText = "<root><text>" + text2 + "</text></root>";
        SAXBuilder sAXBuilder = new SAXBuilder();
        String string = wrappedText;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Document document = sAXBuilder.build((InputStream)new ByteArrayInputStream(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"SAXBuilder().build(wrappedText.byteInputStream())");
        Element element = document.getRootElement().getChild("text");
        if (element == null) {
            throw (Throwable)new IllegalStateException("Can't parse as XML:\n" + text2);
        }
        Element textAsElement = element;
        return this.convert(textAsElement);
    }

    private final List<MessagePart> convert(Element element) {
        if (element == null) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List list2 = new ArrayList();
        for (Content content : element.getContent()) {
            String text2;
            if (content instanceof Text) {
                String string = content.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content.getValue()");
                list2.add(new MessagePart(string, MessagePart.MessageType.TEXT_REGULAR));
                continue;
            }
            if (!(content instanceof Element)) continue;
            XMLOutputter outputter = new XMLOutputter();
            MessagePart.MessageType type2 = MessagePart.MessageType.TEXT_REGULAR;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.unescapeXmlEntities((String)outputter.outputString(((Element)content).getContent())), (String)"StringUtil.unescapeXmlEn\u2026tString(content.content))");
            Function0 textFn2 = (Function0)new Function0<String>(text2){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke() {
                    return this.$text;
                }
                {
                    this.$text = string;
                    super(0);
                }
            };
            String link = null;
            if (((Element)content).getName() != null) {
                String string;
                int n = -1;
                switch (string.hashCode()) {
                    case -1930574291: {
                        if (!string.equals("raw_action")) break;
                        n = 1;
                        break;
                    }
                    case 97: {
                        if (!string.equals("a")) break;
                        n = 2;
                        break;
                    }
                    case -891980137: {
                        if (!string.equals("strong")) break;
                        n = 3;
                        break;
                    }
                    case 3059181: {
                        if (!string.equals("code")) break;
                        n = 4;
                        break;
                    }
                    case -342500282: {
                        if (!string.equals("shortcut")) break;
                        n = 5;
                        break;
                    }
                    case 3226745: {
                        if (!string.equals("icon")) break;
                        n = 6;
                        break;
                    }
                    case -1422950858: {
                        if (!string.equals("action")) break;
                        n = 7;
                        break;
                    }
                    case 104106: {
                        if (!string.equals("ide")) break;
                        n = 8;
                        break;
                    }
                    case -737600009: {
                        if (!string.equals("icon_idx")) break;
                        n = 9;
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        String string2 = "Need to return reflection-based icon processing";
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    case 9: {
                        type2 = MessagePart.MessageType.ICON_IDX;
                        break;
                    }
                    case 4: {
                        type2 = MessagePart.MessageType.CODE;
                        break;
                    }
                    case 5: {
                        type2 = MessagePart.MessageType.SHORTCUT;
                        break;
                    }
                    case 3: {
                        type2 = MessagePart.MessageType.TEXT_BOLD;
                        break;
                    }
                    case 2: {
                        type2 = MessagePart.MessageType.LINK;
                        link = ((Element)content).getAttributeValue("href");
                        break;
                    }
                    case 7: {
                        type2 = MessagePart.MessageType.SHORTCUT;
                        link = text2;
                        textFn2 = (Function0)new Function0<String>(text2){
                            final /* synthetic */ String $text;

                            @NotNull
                            public final String invoke() {
                                KeyStroke shortcutByActionId = KeymapUtil.INSTANCE.getShortcutByActionId(this.$text);
                                return shortcutByActionId != null ? KeymapUtil.INSTANCE.getKeyStrokeText(shortcutByActionId) : KeymapUtil.INSTANCE.getGotoActionText(this.$text);
                            }
                            {
                                this.$text = string;
                                super(0);
                            }
                        };
                        break;
                    }
                    case 1: {
                        type2 = MessagePart.MessageType.SHORTCUT;
                        break;
                    }
                    case 8: {
                        type2 = MessagePart.MessageType.TEXT_REGULAR;
                        textFn2 = convert.2.INSTANCE;
                        break;
                    }
                }
            }
            MessagePart message = new MessagePart(type2, (Function0<String>)textFn2);
            message.setLink(link);
            list2.add(message);
        }
        return list2;
    }

    private MessageFactory() {
    }

    static {
        MessageFactory messageFactory;
        INSTANCE = messageFactory = new MessageFactory();
        Logger logger = Logger.getInstance(MessageFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MessageFactory::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p(MessageFactory $this) {
        MessageFactory messageFactory = $this;
        return LOG;
    }
}

