/*
 * Decompiled with CFR 0.152.
 */
package javaslang.concurrent;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Value;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.concurrent.FutureImpl;
import javaslang.concurrent.Promise;
import javaslang.control.Option;
import javaslang.control.Try;

public interface Future<T>
extends Value<T> {
    public static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public static <T> Future<T> failed(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        return Future.failed(DEFAULT_EXECUTOR_SERVICE, exception);
    }

    public static <T> Future<T> failed(ExecutorService executorService, Throwable exception) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(exception, "exception is null");
        return Promise.failed(executorService, exception).future();
    }

    public static <T> Future<Option<T>> find(Iterable<? extends Future<? extends T>> futures, Predicate<? super T> predicate) {
        return Future.find(DEFAULT_EXECUTOR_SERVICE, futures, predicate);
    }

    public static <T> Future<Option<T>> find(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, Predicate<? super T> predicate) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Promise promise = Promise.make(executorService);
        List<Future<Future>> list = List.ofAll(futures);
        if (list.isEmpty()) {
            promise.success(Option.none());
        } else {
            AtomicInteger count = new AtomicInteger(list.length());
            list.forEach(future -> future.onComplete(result -> {
                AtomicInteger atomicInteger = count;
                synchronized (atomicInteger) {
                    if (!promise.isCompleted()) {
                        boolean wasLast = count.decrementAndGet() == 0;
                        result.filter(predicate).onSuccess(value -> promise.trySuccess(Option.some(value))).onFailure(ignored -> {
                            if (wasLast) {
                                promise.trySuccess(Option.none());
                            }
                        });
                    }
                }
            }));
        }
        return promise.future();
    }

    public static <T> Future<T> firstCompletedOf(Iterable<? extends Future<? extends T>> futures) {
        return Future.firstCompletedOf(DEFAULT_EXECUTOR_SERVICE, futures);
    }

    public static <T> Future<T> firstCompletedOf(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Promise promise = Promise.make(executorService);
        Consumer<Try> completeFirst = promise::tryComplete;
        futures.forEach(future -> future.onComplete(completeFirst));
        return promise.future();
    }

    public static <T, U> Future<U> fold(Iterable<? extends Future<? extends T>> futures, U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        return Future.fold(DEFAULT_EXECUTOR_SERVICE, futures, zero, f);
    }

    public static <T, U> Future<U> fold(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(f, "f is null");
        if (!futures.iterator().hasNext()) {
            return Future.successful(executorService, zero);
        }
        return Future.sequence(executorService, futures).map((T seq) -> seq.foldLeft(zero, f));
    }

    public static <T> Future<T> fromJavaFuture(java.util.concurrent.Future<T> future) {
        Objects.requireNonNull(future, "future is null");
        return Future.of(DEFAULT_EXECUTOR_SERVICE, future::get);
    }

    public static <T> Future<T> fromJavaFuture(ExecutorService executorService, java.util.concurrent.Future<T> future) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(future, "future is null");
        return Future.of(executorService, future::get);
    }

    public static <T> Future<T> fromTry(Try<? extends T> result) {
        return Future.fromTry(DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Future<T> fromTry(ExecutorService executorService, Try<? extends T> result) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(result, "result is null");
        return Promise.fromTry(executorService, result).future();
    }

    public static <T> Future<T> narrow(Future<? extends T> future) {
        return future;
    }

    public static <T> Future<T> of(Try.CheckedSupplier<? extends T> computation) {
        return Future.of(DEFAULT_EXECUTOR_SERVICE, computation);
    }

    public static <T> Future<T> of(ExecutorService executorService, Try.CheckedSupplier<? extends T> computation) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(computation, "computation is null");
        FutureImpl<? extends T> future = new FutureImpl<T>(executorService);
        future.run(computation);
        return future;
    }

    public static <T> Future<T> reduce(Iterable<? extends Future<? extends T>> futures, BiFunction<? super T, ? super T, ? extends T> f) {
        return Future.reduce(DEFAULT_EXECUTOR_SERVICE, futures, f);
    }

    public static <T> Future<T> reduce(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, BiFunction<? super T, ? super T, ? extends T> f) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(f, "f is null");
        if (!futures.iterator().hasNext()) {
            throw new NoSuchElementException("Future.reduce on empty futures");
        }
        return Future.sequence(futures).map((T seq) -> seq.reduceLeft(f));
    }

    public static Future<Void> run(Try.CheckedRunnable unit) {
        return Future.run(DEFAULT_EXECUTOR_SERVICE, unit);
    }

    public static Future<Void> run(ExecutorService executorService, Try.CheckedRunnable unit) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(unit, "unit is null");
        return Future.of(executorService, () -> {
            unit.run();
            return null;
        });
    }

    public static <T> Future<Seq<T>> sequence(Iterable<? extends Future<? extends T>> futures) {
        return Future.sequence(DEFAULT_EXECUTOR_SERVICE, futures);
    }

    public static <T> Future<Seq<T>> sequence(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Future zero = Future.successful(executorService, Stream.empty());
        BiFunction<Future, Future, Future> f = (result, future) -> result.flatMap(seq -> future.map(seq::append));
        return Iterator.ofAll(futures).foldLeft(zero, f);
    }

    public static <T> Future<T> successful(T result) {
        return Future.successful(DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Future<T> successful(ExecutorService executorService, T result) {
        Objects.requireNonNull(executorService, "executorService is null");
        return Promise.successful(executorService, result).future();
    }

    public static <T, U> Future<Seq<U>> traverse(Iterable<? extends T> values, Function<? super T, ? extends Future<? extends U>> mapper) {
        return Future.traverse(DEFAULT_EXECUTOR_SERVICE, values, mapper);
    }

    public static <T, U> Future<Seq<U>> traverse(ExecutorService executorService, Iterable<? extends T> values, Function<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(values, "values is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return Future.sequence(Iterator.ofAll(values).map(mapper));
    }

    default public Future<T> andThen(Consumer<? super Try<T>> action) {
        Objects.requireNonNull(action, "action is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(t -> {
            Try.run(() -> action.accept((Object)t));
            promise.complete(t);
        });
        return promise.future();
    }

    public void await();

    default public boolean cancel() {
        return this.cancel(true);
    }

    public boolean cancel(boolean var1);

    public ExecutorService executorService();

    default public Future<Throwable> failed() {
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isFailure()) {
                promise.success(result.getCause());
            } else {
                promise.failure(new NoSuchElementException("Future.failed completed without a throwable"));
            }
        });
        return promise.future();
    }

    default public Future<T> fallbackTo(Future<? extends T> that) {
        Objects.requireNonNull(that, "that is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(t -> {
            if (t.isSuccess()) {
                promise.complete(t);
            } else {
                that.onComplete(alt -> {
                    if (alt.isSuccess()) {
                        promise.complete(alt);
                    } else {
                        promise.complete(t);
                    }
                });
            }
        });
        return promise.future();
    }

    default public Future<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.filterTry(predicate::test);
    }

    default public Future<T> filterTry(Try.CheckedPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> promise.complete(result.filterTry(predicate)));
        return promise.future();
    }

    default public Option<Throwable> getCause() {
        return this.getValue().map(Try::getCause);
    }

    public Option<Try<T>> getValue();

    public boolean isCompleted();

    default public boolean isSuccess() {
        return this.getValue().map(Try::isSuccess).getOrElse(false);
    }

    default public boolean isFailure() {
        return this.getValue().map(Try::isFailure).getOrElse(false);
    }

    public Future<T> onComplete(Consumer<? super Try<T>> var1);

    default public Future<T> onFailure(Consumer<? super Throwable> action) {
        Objects.requireNonNull(action, "action is null");
        return this.onComplete(result -> result.onFailure(action));
    }

    default public Future<T> onSuccess(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        return this.onComplete(result -> result.onSuccess(action));
    }

    default public Future<T> recover(Function<? super Throwable, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(t -> promise.complete(t.recover(f)));
        return promise.future();
    }

    default public Future<T> recoverWith(Function<? super Throwable, ? extends Future<? extends T>> f) {
        Objects.requireNonNull(f, "f is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(t -> {
            if (t.isFailure()) {
                Try.run(() -> ((Future)f.apply(t.getCause())).onComplete(promise::complete)).onFailure(promise::failure);
            } else {
                promise.complete(t);
            }
        });
        return promise.future();
    }

    default public <U> U transform(Function<? super Future<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    default public <U> Future<Tuple2<T, U>> zip(Future<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(res1 -> {
            if (res1.isFailure()) {
                promise.complete((Try.Failure)res1);
            } else {
                that.onComplete(res2 -> {
                    Try result = res1.flatMap((? super T t) -> res2.map((T u) -> Tuple.of(t, u)));
                    promise.complete(result);
                });
            }
        });
        return promise.future();
    }

    default public <U> Future<U> flatMap(Function<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.flatMapTry(mapper::apply);
    }

    default public <U> Future<U> flatMapTry(Try.CheckedFunction<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> result.mapTry(mapper).onSuccess(promise::completeWith).onFailure(promise::failure));
        return promise.future();
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        this.onComplete(result -> result.forEach(action));
    }

    @Override
    default public T get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("get on failed future");
        }
        return this.getValue().get().get();
    }

    @Override
    default public boolean isEmpty() {
        if (!this.isCompleted()) {
            this.await();
        }
        return this.getValue().get().isEmpty();
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    default public <U> Future<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.mapTry(mapper::apply);
    }

    default public <U> Future<U> mapTry(Try.CheckedFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> promise.complete(result.mapTry(mapper)));
        return promise.future();
    }

    default public Future<T> orElse(Future<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isSuccess()) {
                promise.complete(result);
            } else {
                other.onComplete(promise::complete);
            }
        });
        return promise.future();
    }

    default public Future<T> orElse(Supplier<? extends Future<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        Promise promise = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isSuccess()) {
                promise.complete(result);
            } else {
                ((Future)supplier.get()).onComplete(promise::complete);
            }
        });
        return promise.future();
    }

    @Override
    default public Future<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        this.onSuccess(action::accept);
        return this;
    }

    @Override
    default public String stringPrefix() {
        return "Future";
    }
}

