/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.repl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0014J\u0018\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0016H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "history", "Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "clearState", "", "executeStatement", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "needProcessToStart", "", "sendCommandToProcess", "command", "", "startExecution", "stopExecution", "callback", "Lkotlin/Function0;", "ReplHistory", "ReplOSProcessHandler", "kotlin.jvm"})
public final class KtScratchReplExecutor
extends SequentialScratchExecutor {
    private final ReplHistory history;
    private volatile OSProcessHandler osProcessHandler;

    @Override
    protected void startExecution() {
        block0: {
            Module module = this.getFile().getModule();
            GeneralCommandLine cmdLine = KotlinConsoleKeeper.Companion.createReplCommandLine(this.getFile().getProject(), module);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Execute REPL: " + cmdLine.getCommandLineString());
            OSProcessHandler oSProcessHandler = this.osProcessHandler = (OSProcessHandler)new ReplOSProcessHandler(cmdLine);
            if (oSProcessHandler == null) break block0;
            oSProcessHandler.startNotify();
        }
    }

    @Override
    protected void stopExecution(@Nullable Function0<Unit> callback) {
        OSProcessHandler processHandler = this.osProcessHandler;
        if (processHandler == null) {
            Function0<Unit> function0 = callback;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            return;
        }
        try {
            if (callback != null) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(callback){
                    final /* synthetic */ Function0 $callback;

                    public void processTerminated(@NotNull ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$callback.invoke();
                    }
                    {
                        this.$callback = $captured_local_variable$0;
                    }
                });
            }
            this.sendCommandToProcess(":quit");
        }
        catch (Exception e) {
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.stop.repl.process", new Object[0]), e, false);
            processHandler.destroyProcess();
            this.clearState();
        }
    }

    private final void clearState() {
        this.history.clear();
        this.osProcessHandler = null;
        this.getHandler().onFinish(this.getFile());
    }

    @Override
    public void executeStatement(@NotNull ScratchExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.needProcessToStart()) {
            this.startExecution();
        }
        this.history.addEntry(expression);
        try {
            String string = expression.getElement().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.element.text");
            this.sendCommandToProcess(string);
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[1];
            String string = expression.getElement().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.element.text");
            objectArray[0] = string;
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.execute.statement.0", objectArray), e, true);
        }
    }

    @Override
    protected boolean needProcessToStart() {
        return this.osProcessHandler == null;
    }

    private final void sendCommandToProcess(String command) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Send to REPL: " + command);
        Object object = this.osProcessHandler;
        if (object == null || (object = object.getProcessInput()) == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), (String)"<p>Broken execute stream</p>", null, (int)4, null);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"osProcessHandler?.proces\u2026oken execute stream</p>\")");
        Object processInputOS = object;
        Object object2 = this.osProcessHandler;
        if (object2 == null || (object2 = object2.getCharset()) == null) {
            object2 = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"osProcessHandler?.charset ?: Charsets.UTF_8");
        Object charset = object2;
        String xmlRes = ReplUtilKt.replInputAsXml((String)command);
        String string = xmlRes + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ((OutputStream)processInputOS).write(bytes);
        ((OutputStream)processInputOS).flush();
    }

    public KtScratchReplExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
        this.history = new ReplHistory();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lkotlin/collections/ArrayList;", "processedEntriesCount", "", "addEntry", "", "entry", "clear", "entryProcessed", "isAllProcessed", "", "lastProcessedEntry", "lastUnprocessedEntry", "kotlin.jvm"})
    private static final class ReplHistory {
        private ArrayList<ScratchExpression> entries;
        private int processedEntriesCount;

        public final void addEntry(@NotNull ScratchExpression entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entries.add(entry);
        }

        @Nullable
        public final ScratchExpression lastUnprocessedEntry() {
            ArrayList<ScratchExpression> arrayList = this.entries;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<ScratchExpression> it = arrayList;
            boolean bl3 = false;
            ArrayList<ScratchExpression> arrayList2 = this.processedEntriesCount < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(this.processedEntriesCount) : null;
        }

        @Nullable
        public final ScratchExpression lastProcessedEntry() {
            if (this.processedEntriesCount < 1) {
                return null;
            }
            int lastProcessedEntryIndex = this.processedEntriesCount - 1;
            ArrayList<ScratchExpression> arrayList = this.entries;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<ScratchExpression> it = arrayList;
            boolean bl3 = false;
            ArrayList<ScratchExpression> arrayList2 = lastProcessedEntryIndex < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(lastProcessedEntryIndex) : null;
        }

        public final void entryProcessed() {
            int n = this.processedEntriesCount;
            this.processedEntriesCount = n + 1;
        }

        public final void clear() {
            boolean bl = false;
            this.entries = new ArrayList();
            this.processedEntriesCount = 0;
        }

        public final boolean isAllProcessed() {
            return this.entries.size() == this.processedEntriesCount;
        }

        public ReplHistory() {
            boolean bl = false;
            this.entries = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001c\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplOSProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "handleReplMessage", "", "text", "", "notifyProcessTerminated", "exitCode", "", "notifyTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "parseReplOutput", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "kotlin.jvm"})
    private final class ReplOSProcessHandler
    extends OSProcessHandler {
        private final DocumentBuilderFactory factory;

        public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
            block2: {
                Key<?> key;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (StringsKt.startsWith$default((String)text, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
                        return;
                    }
                    key = outputType;
                    if (!Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) break block1;
                    this.handleReplMessage(text);
                    break block2;
                }
                if (!Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDERR)) break block2;
                ScratchExecutor.errorOccurs$default(KtScratchReplExecutor.this, text, null, false, 6, null);
            }
        }

        protected void notifyProcessTerminated(int exitCode) {
            KtScratchReplExecutor.this.clearState();
            super.notifyProcessTerminated(exitCode);
        }

        private final InputSource strToSource(String s, Charset encoding) {
            String string = s;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(encoding);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return new InputSource(new ByteArrayInputStream(byArray));
        }

        static /* synthetic */ InputSource strToSource$default(ReplOSProcessHandler replOSProcessHandler, String string, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return replOSProcessHandler.strToSource(string, charset);
        }

        private final void handleReplMessage(String text) {
            Document output;
            Document document;
            if (StringsKt.isBlank((CharSequence)text)) {
                return;
            }
            try {
                document = this.factory.newDocumentBuilder().parse(ReplOSProcessHandler.strToSource$default(this, text, null, 2, null));
            }
            catch (Exception e) {
                KtScratchReplExecutor.this.getHandler().error(KtScratchReplExecutor.this.getFile(), "Couldn't parse REPL output: " + text);
                return;
            }
            Document document2 = output = document;
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"output");
            Node node = document2.getFirstChild();
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element root = (Element)node;
            String outputType = root.getAttribute("type");
            String string = root.getTextContent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.textContent");
            String content = ReplUtilKt.replRemoveLineBreaksInTheEnd((String)ReplUtilKt.replNormalizeLineBreaks((String)ReplUtilKt.replUnescapeLineBreaks((String)string)));
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "REPL output: " + outputType + ' ' + content);
            if (SetsKt.setOf((Object[])new String[]{"SUCCESS", "COMPILE_ERROR", "INTERNAL_ERROR", "RUNTIME_ERROR", "READLINE_END"}).contains(outputType)) {
                KtScratchReplExecutor.this.history.entryProcessed();
                if (KtScratchReplExecutor.this.history.isAllProcessed()) {
                    KtScratchReplExecutor.this.getHandler().onFinish(KtScratchReplExecutor.this.getFile());
                }
            }
            String string2 = outputType;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputType");
            ScratchOutput result = this.parseReplOutput(content, string2);
            if (result != null) {
                ScratchExpression lastExpression;
                ScratchExpression scratchExpression = lastExpression = Intrinsics.areEqual((Object)outputType, (Object)"USER_OUTPUT") ? KtScratchReplExecutor.this.history.lastUnprocessedEntry() : KtScratchReplExecutor.this.history.lastProcessedEntry();
                if (lastExpression != null) {
                    KtScratchReplExecutor.this.getHandler().handle(KtScratchReplExecutor.this.getFile(), lastExpression, result);
                }
            }
        }

        private final ScratchOutput parseReplOutput(String text, String outputType) {
            ScratchOutput scratchOutput;
            switch (outputType) {
                case "USER_OUTPUT": {
                    scratchOutput = new ScratchOutput(text, ScratchOutputType.OUTPUT);
                    break;
                }
                case "REPL_RESULT": {
                    scratchOutput = new ScratchOutput(text, ScratchOutputType.RESULT);
                    break;
                }
                case "RUNTIME_ERROR": 
                case "INTERNAL_ERROR": 
                case "COMPILE_ERROR": 
                case "REPL_INCOMPLETE": {
                    scratchOutput = new ScratchOutput(text, ScratchOutputType.ERROR);
                    break;
                }
                default: {
                    scratchOutput = null;
                }
            }
            return scratchOutput;
        }

        public ReplOSProcessHandler(GeneralCommandLine cmd) {
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            super(cmd);
            this.factory = DocumentBuilderFactory.newInstance();
        }
    }
}

