/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.GradleUtil;
import com.android.tools.idea.gradle.dsl.model.CachedValue;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslSimpleExpression
extends GradleDslElementImpl
implements GradleDslExpression {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    private boolean myIsReference;
    @Nullable
    private PsiElement myUnsavedConfigBlock;
    @Nullable
    protected PsiElement myExpression;
    @Nullable
    protected ThreeState myHasCycle;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myResolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myUnresolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myRawCachedValue;

    protected GradleDslSimpleExpression(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name, @Nullable PsiElement expression) {
        if (name == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name);
        this.myExpression = expression;
        this.myHasCycle = ThreeState.UNSURE;
        this.resolve();
        this.myResolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceValue);
        this.myUnresolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceUnresolvedValue);
        this.myRawCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceRawValue);
    }

    @Nullable
    public PsiElement getUnsavedConfigBlock() {
        return this.myUnsavedConfigBlock;
    }

    public void setUnsavedConfigBlock(@Nullable PsiElement configBlock) {
        this.myUnsavedConfigBlock = configBlock;
    }

    public void setConfigBlock(@NotNull PsiElement block) {
        if (block == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(1);
        }
        Preconditions.checkState((this.getPsiElement() == null ? 1 : 0) != 0, (Object)"Can't add configuration block to an existing DSL literal.");
        this.myUnsavedConfigBlock = block;
        this.setModified();
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.myExpression;
    }

    public void setExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(2);
        }
        this.myExpression = expression;
    }

    @Nullable
    public final Object getValue() {
        return this.myResolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceValue();

    @Nullable
    public final Object getUnresolvedValue() {
        return this.myUnresolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceUnresolvedValue();

    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        Object value;
        if (clazz == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(3);
        }
        if ((value = this.getValue()) != null && clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        return null;
    }

    @Nullable
    public <T> T getUnresolvedValue(@NotNull Class<T> clazz) {
        Object value;
        if (clazz == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(4);
        }
        if ((value = this.getUnresolvedValue()) != null && clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        return null;
    }

    public abstract void setValue(@NotNull Object var1);

    @Nullable
    public final Object getRawValue() {
        return this.myRawCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceRawValue();

    @Override
    @NotNull
    public abstract GradleDslSimpleExpression copy();

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        List<GradleReferenceInjection> list = this.myDependencies.stream().filter(e -> e.isResolved()).collect(Collectors.toList());
        if (list == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isReference() {
        return this.myIsReference;
    }

    public void setReference(boolean isReference) {
        this.myIsReference = isReference;
    }

    @Nullable
    public String getReferenceText() {
        return null;
    }

    @Override
    protected void reset() {
        this.myRawCachedValue.clear();
        this.myUnresolvedCachedValue.clear();
        this.myResolvedCachedValue.clear();
    }

    @Nullable
    public GradleDslElement resolveReference(@NotNull String referenceText, boolean resolveWithOrder) {
        String fullTextReference;
        GradleDslElement resolvedElement;
        GradleDslFile dslFile;
        int index;
        if (referenceText == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(6);
        }
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        referenceText = parser.convertReferenceText(searchStartElement, referenceText);
        List<String> referenceTextSegments = Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslSimpleExpression.resolveProjectReference(searchStartElement, (String)referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index, segmentCount);
            resolvedElement = GradleDslSimpleExpression.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, parser, resolveWithOrder);
        }
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (resolvedElement == null) {
            resolvedElement = GradleDslSimpleExpression.resolveReferenceInParentModules(dslFile2, referenceTextSegments, parser);
        }
        if ("rootDir".equals(fullTextReference = String.join((CharSequence)".", referenceTextSegments))) {
            return new GradleDslGlobalValue(dslFile2, GradleUtil.getBaseDirPath(dslFile2.getProject()).getPath());
        }
        if ("projectDir".equals(fullTextReference)) {
            return new GradleDslGlobalValue(dslFile2, dslFile2.getDirectoryPath().getPath());
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(7);
        }
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            VirtualFile settingFile = dslFile.tryToFindSettingsFile();
            if (settingFile == null) {
                return null;
            }
            GradleSettingsFile file = dslFile.getContext().getOrCreateSettingsFile(settingFile);
            GradleSettingsModelImpl model = new GradleSettingsModelImpl(file);
            File moduleDirectory = model.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslSimpleExpression.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index) {
        if (index == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(8);
        }
        if (index.startsWith(SINGLE_QUOTES) && index.endsWith(SINGLE_QUOTES) || index.startsWith(DOUBLE_QUOTES) && index.endsWith(DOUBLE_QUOTES)) {
            String string = index.substring(1, index.length() - 1);
            if (string == null) {
                GradleDslSimpleExpression.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = index;
        if (string == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static GradleDslElement dereference(@NotNull GradleDslElement element, @NotNull String index) {
        if (element == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(11);
        }
        if (index == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(12);
        }
        if (element instanceof GradleDslExpressionList) {
            int offset;
            try {
                offset = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GradleDslExpressionList list = (GradleDslExpressionList)element;
            if (list.getExpressions().size() <= offset) {
                return null;
            }
            return list.getExpressions().get(offset);
        }
        if (element instanceof GradleDslExpressionMap) {
            GradleDslExpressionMap map = (GradleDslExpressionMap)element;
            index = GradleDslSimpleExpression.stripQuotes(index);
            return map.getPropertyElement(index);
        }
        if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
            GradleDslElement value = PropertyUtil.followElement((GradleDslLiteral)element);
            if (value == null) {
                return null;
            }
            return GradleDslSimpleExpression.dereference(value, index);
        }
        return null;
    }

    @Nullable
    public static GradlePropertiesDslElement dereferencePropertiesElement(@NotNull GradlePropertiesDslElement element, @NotNull String index) {
        GradleDslElement result;
        if (element == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(13);
        }
        if (index == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(14);
        }
        if ((result = GradleDslSimpleExpression.dereference(element, index)) instanceof GradleDslLiteral && ((GradleDslLiteral)result).isReference()) {
            result = PropertyUtil.followElement((GradleDslLiteral)result);
        }
        if (result instanceof GradlePropertiesDslElement) {
            return (GradlePropertiesDslElement)result;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties, @NotNull String name, GradleDslNameConverter converter, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher;
        if (properties == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(15);
        }
        if (name == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(16);
        }
        if (!(indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name)).find()) {
            String modelName = converter.modelNameForParent(name, properties);
            return sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        }
        if (indexMatcher.groupCount() != 2) {
            return null;
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null) {
            return null;
        }
        String modelName = converter.modelNameForParent(elementName, properties);
        GradleDslElement element = sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            if (indexMatcher.groupCount() != 2) {
                return null;
            }
            indexParts.add(indexMatcher.group(1));
        }
        while (!indexParts.isEmpty()) {
            String index = (String)indexParts.pop();
            if (element == null) {
                return null;
            }
            element = GradleDslSimpleExpression.dereference(element, index);
        }
        return element;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties, @NotNull List<String> nameParts, GradleDslNameConverter converter, @NotNull List<GradleDslElement> trace) {
        if (properties == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(17);
        }
        if (nameParts == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(18);
        }
        if (trace == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(19);
        }
        int traceIndex = trace.size() - 1;
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            GradleDslElement element = GradleDslSimpleExpression.extractElementFromProperties(properties, nameParts.get(i), converter, i == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
                element = PropertyUtil.followElement((GradleDslLiteral)element);
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element)) {
                return null;
            }
            properties = (GradlePropertiesDslElement)element;
        }
        return GradleDslSimpleExpression.extractElementFromProperties(properties, nameParts.get(nameParts.size() - 1), converter, nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element, @NotNull List<String> nameParts, GradleDslNameConverter converter, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        if (element == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(20);
        }
        if (nameParts == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(21);
        }
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element);
        }
        while (ignoreParentNumber-- > 0 && element != null && !(element instanceof GradleDslFile)) {
            element = element.getParent();
        }
        while (element != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element, nameParts, converter, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(lastElement, ExtDslElement.EXT.name, false)) instanceof ExtDslElement && (extPropertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, converter, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(element, BuildScriptDslElement.BUILDSCRIPT.name, false)) instanceof BuildScriptDslElement && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, nameParts, converter, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element);
            }
            if (element instanceof BuildScriptDslElement) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, GradleDslNameConverter converter, boolean resolveWithOrder) {
        GradleDslFile parentModuleDslFile;
        GradleDslElement bsElement;
        GradleDslElement element;
        if (startElement == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(22);
        }
        if (referenceText == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(23);
        }
        if ((element = GradleDslSimpleExpression.resolveReferenceOnElement(startElement, referenceText, converter, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size())) != null) {
            return element;
        }
        String text = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceInPropertiesFile(dslFile, text);
        if (propertyElement != null) {
            return propertyElement;
        }
        BuildScriptDslElement bsDslElement = dslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        if (bsDslElement != null && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
            return bsElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslSimpleExpression.resolveReferenceInPropertiesFile(rootProjectDslFile, text);
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull List<String> referenceText, GradleDslNameConverter converter) {
        if (dslFile == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(24);
        }
        if (referenceText == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(25);
        }
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement(ExtDslElement.EXT);
            if (extDslElement != null && (extPropertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement(extDslElement, referenceText, converter, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentDslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceInPropertiesFile(parentDslFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile;
        if (buildDslFile == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(26);
        }
        if (referenceText == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(27);
        }
        return (propertiesDslFile = buildDslFile.getSiblingDslFile()) != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslSimpleExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    protected void valueChanged() {
        this.myHasCycle = ThreeState.UNSURE;
        this.setModified();
    }

    public boolean hasCycle() {
        if (this.myHasCycle != ThreeState.UNSURE) {
            return this.myHasCycle == ThreeState.YES;
        }
        return GradleDslSimpleExpression.hasCycle(this, new HashSet<GradleDslSimpleExpression>(), new HashSet<GradleDslSimpleExpression>());
    }

    private static boolean hasCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (element == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(28);
        }
        if (seen == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(29);
        }
        if (cycleFree == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(30);
        }
        if (element.myHasCycle != ThreeState.UNSURE) {
            return element.myHasCycle == ThreeState.YES;
        }
        boolean hasCycle = GradleDslSimpleExpression.checkCycle(element, seen, cycleFree);
        element.myHasCycle = hasCycle ? ThreeState.YES : ThreeState.NO;
        return hasCycle;
    }

    private static boolean checkCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (element == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(31);
        }
        if (seen == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(32);
        }
        if (cycleFree == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(33);
        }
        if (cycleFree.contains(element) || element.getExpression() == null) {
            return false;
        }
        if (seen.contains(element)) {
            return true;
        }
        seen.add(element);
        List<GradleReferenceInjection> injections = element.getResolvedVariables();
        for (GradleReferenceInjection injection : injections) {
            boolean hasCycle;
            if (injection.getToBeInjectedExpression() == null || !(hasCycle = GradleDslSimpleExpression.hasCycle(injection.getToBeInjectedExpression(), seen, cycleFree))) continue;
            seen.remove(element);
            return true;
        }
        seen.remove(element);
        cycleFree.add(element);
        return false;
    }

    @Override
    public void resolve() {
        this.setupDependencies(this.myExpression);
    }

    @NotNull
    protected List<GradleReferenceInjection> fetchDependencies(@Nullable PsiElement element) {
        if (element == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleDslSimpleExpression.$$$reportNull$$$0(34);
            }
            return immutableList;
        }
        List list = (List)ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().getInjections(this, element));
        if (list == null) {
            GradleDslSimpleExpression.$$$reportNull$$$0(35);
        }
        return list;
    }

    protected void setupDependencies(@Nullable PsiElement element) {
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().unregisterDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().unregisterUnresolvedReference((GradleReferenceInjection)e));
        this.myDependencies.clear();
        this.myDependencies.addAll(this.fetchDependencies(element));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().registerDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslSimpleExpression";
                break;
            }
            case 6: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 11: 
            case 13: 
            case 20: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seen";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycleFree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslSimpleExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfigBlock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedValue";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dereferencePropertiesElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractElementFromProperties";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnPropertiesElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInSameModule";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInParentModules";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInPropertiesFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasCycle";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkCycle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

