/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.util.Objects;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class ClasspathResourceSelector
implements DiscoverySelector {
    private final String classpathResourceName;

    ClasspathResourceSelector(String classpathResourceName) {
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        this.classpathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
    }

    public String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceSelector that = (ClasspathResourceSelector)o;
        return Objects.equals(this.classpathResourceName, that.classpathResourceName);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.classpathResourceName.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("classpathResourceName", this.classpathResourceName).toString();
    }
}

