/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.util;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public class ToStringBuilder {
    private final Class<?> type;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this.type = Preconditions.notNull(obj, "Object must not be null").getClass();
    }

    public ToStringBuilder(Class<?> type) {
        this.type = Preconditions.notNull(type, "Class must not be null");
    }

    public ToStringBuilder append(String name, Object value) {
        Preconditions.notBlank(name, "Name must not be null or blank");
        this.values.add(name + " = " + this.toString(value));
        return this;
    }

    private String toString(Object obj) {
        return obj instanceof CharSequence ? "'" + obj + "'" : StringUtils.nullSafeToString(obj);
    }

    public String toString() {
        return this.type.getSimpleName() + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

