/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Collection<String> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                StoredConfig config = this.repo.getConfig();
                ArrayList<String> initialized = new ArrayList<String>();
                while (generator.next()) {
                    if (generator.getConfigUrl() != null) continue;
                    String path = generator.getPath();
                    String name = generator.getModuleName();
                    String url = generator.getRemoteUrl();
                    String update = generator.getModulesUpdate();
                    if (url != null) {
                        config.setString("submodule", name, "url", url);
                    }
                    if (update != null) {
                        config.setString("submodule", name, "update", update);
                    }
                    if (url == null && update == null) continue;
                    initialized.add(path);
                }
                if (!initialized.isEmpty()) {
                    config.save();
                }
                return initialized;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

