/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Status;
import org.gradle.internal.impldep.org.eclipse.jgit.api.StatusCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.NoWorkTreeException;
import org.gradle.internal.impldep.org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FileUtils;

public class CleanCommand
extends GitCommand<Set<String>> {
    private Set<String> paths = Collections.emptySet();
    private boolean dryRun;
    private boolean directories;
    private boolean ignore = true;
    private boolean force = false;

    protected CleanCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Set<String> call() throws NoWorkTreeException, GitAPIException {
        Set<String> files = new TreeSet<String>();
        try {
            try {
                StatusCommand command = new StatusCommand(this.repo);
                Status status = command.call();
                TreeSet<String> untrackedFiles = new TreeSet<String>(status.getUntracked());
                TreeSet<String> untrackedDirs = new TreeSet<String>(status.getUntrackedFolders());
                FS fs = this.getRepository().getFS();
                for (String p : status.getIgnoredNotInIndex()) {
                    File f = new File(this.repo.getWorkTree(), p);
                    if (fs.isFile(f) || fs.isSymLink(f)) {
                        untrackedFiles.add(p);
                        continue;
                    }
                    if (!fs.isDirectory(f)) continue;
                    untrackedDirs.add(p);
                }
                Set<String> filtered = this.filterFolders(untrackedFiles, untrackedDirs);
                Set<String> notIgnoredFiles = this.filterIgnorePaths(filtered, status.getIgnoredNotInIndex(), true);
                Set<String> notIgnoredDirs = this.filterIgnorePaths(untrackedDirs, status.getIgnoredNotInIndex(), false);
                for (String file : notIgnoredFiles) {
                    if (!this.paths.isEmpty() && !this.paths.contains(file)) continue;
                    files = this.cleanPath(file, files);
                }
                for (String dir2 : notIgnoredDirs) {
                    if (!this.paths.isEmpty() && !this.paths.contains(dir2)) continue;
                    files = this.cleanPath(dir2, files);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        finally {
            if (!this.dryRun && !files.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(null, files));
            }
        }
        return files;
    }

    private Set<String> cleanPath(String path, Set<String> inFiles) throws IOException {
        File curFile = new File(this.repo.getWorkTree(), path);
        if (curFile.isDirectory()) {
            if (this.directories) {
                if (new File(curFile, ".git").exists()) {
                    if (this.force) {
                        if (!this.dryRun) {
                            FileUtils.delete(curFile, 5);
                        }
                        inFiles.add(String.valueOf(path) + "/");
                    }
                } else {
                    if (!this.dryRun) {
                        FileUtils.delete(curFile, 5);
                    }
                    inFiles.add(String.valueOf(path) + "/");
                }
            }
        } else {
            if (!this.dryRun) {
                FileUtils.delete(curFile, 4);
            }
            inFiles.add(path);
        }
        return inFiles;
    }

    private Set<String> filterIgnorePaths(Set<String> inputPaths, Set<String> ignoredNotInIndex, boolean exact) {
        if (this.ignore) {
            TreeSet<String> filtered = new TreeSet<String>(inputPaths);
            block0: for (String path : inputPaths) {
                for (String ignored : ignoredNotInIndex) {
                    if ((!exact || !path.equals(ignored)) && (exact || !path.startsWith(ignored))) continue;
                    filtered.remove(path);
                    continue block0;
                }
            }
            return filtered;
        }
        return inputPaths;
    }

    private Set<String> filterFolders(Set<String> untracked, Set<String> untrackedFolders) {
        TreeSet<String> filtered = new TreeSet<String>(untracked);
        block0: for (String file : untracked) {
            for (String folder : untrackedFolders) {
                if (!file.startsWith(folder)) continue;
                filtered.remove(file);
                continue block0;
            }
        }
        return filtered;
    }

    public CleanCommand setPaths(Set<String> paths) {
        this.paths = paths;
        return this;
    }

    public CleanCommand setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public CleanCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public CleanCommand setCleanDirectories(boolean dirs) {
        this.directories = dirs;
        return this;
    }

    public CleanCommand setIgnore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }
}

