/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0014J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.gradle.java"})
public final class GradleProjectExtensionContributor
extends NonCodeMembersContributor {
    @Nullable
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection extensions;
        Collection collection;
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        boolean processMethods = ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor);
        boolean processProperties = ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor);
        if (!processMethods && !processProperties) {
            return;
        }
        PsiFile psiFile = containingFile = place.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)psiFile);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData extensionsData = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Map map = extensionsData.extensions;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"extensionsData.extensions");
        Map allExtensions = map;
        if (name == null) {
            collection = allExtensions.values();
        } else {
            GradleExtensionsSettings.GradleExtension gradleExtension = (GradleExtensionsSettings.GradleExtension)allExtensions.get(name);
            if (gradleExtension == null) {
                return;
            }
            collection = extensions = (Collection)CollectionsKt.listOf((Object)gradleExtension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance((Project)containingFile.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026e(containingFile.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        PsiManager manager = containingFile.getManager();
        for (GradleExtensionsSettings.GradleExtension extension : extensions) {
            PsiType type;
            GrTypeElement grTypeElement = factory.createTypeElement(extension.rootTypeFqn, (PsiElement)containingFile);
            Intrinsics.checkNotNullExpressionValue((Object)grTypeElement, (String)"factory.createTypeElemen\u2026tTypeFqn, containingFile)");
            Intrinsics.checkNotNullExpressionValue((Object)grTypeElement.getType(), (String)"factory.createTypeElemen\u2026Fqn, containingFile).type");
            if (processProperties) {
                String string = extension.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extension.name");
                GradleExtensionProperty extensionProperty = new GradleExtensionProperty(string, type, (PsiElement)containingFile);
                if (!processor.execute((PsiElement)extensionProperty, state)) {
                    return;
                }
            }
            if (!processMethods) continue;
            GrLightMethodBuilder grLightMethodBuilder = new GrLightMethodBuilder(manager, extension.name);
            boolean bl = false;
            boolean bl2 = false;
            GrLightMethodBuilder $this$apply = grLightMethodBuilder;
            boolean bl3 = false;
            $this$apply.setReturnType(type);
            $this$apply.addParameter("configuration", (PsiType)TypesUtil.createType((String)"groovy.lang.Closure", (PsiElement)((PsiElement)containingFile)));
            GrLightMethodBuilder extensionMethod = grLightMethodBuilder;
            if (processor.execute((PsiElement)extensionMethod, state)) continue;
            return;
        }
    }
}

