/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestLocationDataRule
implements GetDataRule {
    @Nullable
    public Object getData(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            TestLocationDataRule.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataProvider);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataProvider);
        if (project != null && file != null) {
            List<Location> locations = TestLocationDataRule.collectRelativeLocations(project, file);
            return locations.size() == 1 ? locations.get(0) : null;
        }
        return null;
    }

    @NotNull
    protected static List<Location> collectRelativeLocations(Project project, VirtualFile file) {
        if (DumbService.isDumb((Project)project)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                TestLocationDataRule.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInContent(file) && !fileIndex.isInSource(file) && !fileIndex.isInLibraryClasses(file)) {
            String relativePath;
            VirtualFile parent = file.getParent();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
            if (contentRoot != null && parent != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)contentRoot, (char)'/')) != null) {
                PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
                List words = StringUtil.getWordsIn((String)relativePath);
                words.sort((o1, o2) -> o2.length() - o1.length());
                GlobalSearchScope testScope = GlobalSearchScopesCore.projectTestScope((Project)project);
                HashSet resultFiles = null;
                for (String word : words) {
                    if (word.length() < 5) continue;
                    HashSet files = new HashSet();
                    searchHelper.processAllFilesWithWordInLiterals(word, testScope, (Processor)new CommonProcessors.CollectProcessor(files));
                    if (resultFiles == null) {
                        resultFiles = files;
                    } else {
                        resultFiles.retainAll(files);
                    }
                    if (!resultFiles.isEmpty()) continue;
                    break;
                }
                if (resultFiles != null) {
                    Iterator iterator = resultFiles.iterator();
                    while (iterator.hasNext()) {
                        if (VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)((PsiFile)iterator.next()).getVirtualFile(), (boolean)true)) continue;
                        iterator.remove();
                    }
                    String fileName = file.getName();
                    String nameWithoutExtension = file.getNameWithoutExtension();
                    for (PsiFile resultFile : resultFiles) {
                        PsiClass[] classes;
                        if (!(resultFile instanceof PsiClassOwner) || (classes = ((PsiClassOwner)resultFile).getClasses()).length <= 0) continue;
                        ContainerUtil.addIfNotNull(locations, (Object)TestLocationDataRule.getLocation(project, fileName, nameWithoutExtension, classes[0]));
                    }
                }
            }
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            TestLocationDataRule.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static Location getLocation(Project project, String fileName, String nameWithoutExtension, PsiClass aClass) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{TestDataPath.class.getName()});
        if (annotation != null) {
            Location parameterizedLocation = PsiMemberParameterizedLocation.getParameterizedLocation((PsiClass)aClass, (String)("[" + fileName + "]"), (String)Parameterized.class.getName());
            if (parameterizedLocation != null) {
                return parameterizedLocation;
            }
            if (StringUtil.isJavaIdentifier((String)nameWithoutExtension)) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiMethod method = aClass.findMethodBySignature(elementFactory.createMethod("test" + nameWithoutExtension, (PsiType)PsiType.VOID), true);
                if (method != null) {
                    return MethodLocation.elementInClass((PsiMethod)method, (PsiClass)aClass);
                }
                method = aClass.findMethodBySignature(elementFactory.createMethod("test" + StringUtil.capitalize((String)nameWithoutExtension), (PsiType)PsiType.VOID), true);
                if (method != null) {
                    return MethodLocation.elementInClass((PsiMethod)method, (PsiClass)aClass);
                }
            }
            return new PsiLocation(project, (PsiElement)aClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestLocationDataRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestLocationDataRule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelativeLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

