/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.actions.NewMessageBundleActionKt;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/devkit/i18n/IntelliJProjectResourceBundleManager;", "Lcom/intellij/lang/properties/psi/ResourceBundleManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canShowJavaCodeInfo", "", "escapeValue", "", "value", "getConcatenationTemplateName", "getI18nizedTextGenerator", "Lcom/intellij/lang/properties/psi/I18nizedTextGenerator;", "getResourceBundle", "Lcom/intellij/psi/PsiClass;", "getTemplateName", "isActive", "context", "Lcom/intellij/psi/PsiFile;", "suggestPropertiesFiles", "", "contextModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.devkit"})
public final class IntelliJProjectResourceBundleManager
extends ResourceBundleManager {
    public boolean isActive(@NotNull PsiFile context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return PsiUtil.isIdeaProject(this.myProject);
    }

    @NotNull
    public String escapeValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.replace$default((String)value, (String)"&", (String)"\\&", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggestPropertiesFiles(@NotNull Set<Module> contextModules) {
        void preferredFiles;
        List files;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(contextModules, (String)"contextModules");
        Iterable iterable = contextModules;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Module module = (Module)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string = NewMessageBundleActionKt.generateDefaultBundleName((Module)it);
            collection.add(string);
        }
        HashSet preferredBundleNames = (HashSet)destination$iv;
        List list = files = super.suggestPropertiesFiles(contextModules);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"files");
        Iterable $this$partition$iv = list;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (preferredBundleNames.contains(FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)it)))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        destination$iv = (List)pair.component1();
        List otherFiles = (List)pair.component2();
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)((Collection)preferredFiles), (Iterable)otherFiles));
    }

    @Nullable
    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return new I18nizedTextGenerator(this){
            final /* synthetic */ IntelliJProjectResourceBundleManager this$0;

            @NotNull
            public String getI18nizedText(@NotNull String propertyKey, @Nullable PropertiesFile propertiesFile, @Nullable PsiElement context) {
                Intrinsics.checkNotNullParameter((Object)propertyKey, (String)"propertyKey");
                return this.getI18nizedConcatenationText(propertyKey, "", propertiesFile, context);
            }

            @NotNull
            public String getI18nizedConcatenationText(@NotNull String propertyKey, @NotNull String parametersString, @Nullable PropertiesFile propertiesFile, @Nullable PsiElement context) {
                Intrinsics.checkNotNullParameter((Object)propertyKey, (String)"propertyKey");
                Intrinsics.checkNotNullParameter((Object)parametersString, (String)"parametersString");
                String bundleClassName = this.suggestBundleClassName(propertiesFile, context);
                CharSequence charSequence = parametersString;
                boolean bl = false;
                String args = charSequence.length() > 0 ? ", " + parametersString : "";
                return bundleClassName + ".message(\"" + propertyKey + '\"' + args + ')';
            }

            private final String suggestBundleClassName(PropertiesFile propertiesFile, PsiElement context) {
                if (propertiesFile == null) {
                    return "UnknownBundle";
                }
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"propertiesFile.virtualFile");
                String string = virtualFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertiesFile.virtualFile.nameWithoutExtension");
                String bundleName = string;
                PsiElement psiElement = context;
                if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
                    psiElement = GlobalSearchScope.projectScope((Project)IntelliJProjectResourceBundleManager.access$getMyProject$p(this.this$0));
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"context?.resolveScope ?:\u2026e.projectScope(myProject)");
                PsiElement scope = psiElement;
                Object[] objectArray = PsiShortNamesCache.getInstance((Project)IntelliJProjectResourceBundleManager.access$getMyProject$p(this.this$0)).getClassesByName(bundleName, (GlobalSearchScope)scope);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"PsiShortNamesCache.getIn\u2026ByName(bundleName, scope)");
                Object[] classesByName = objectArray;
                Object object = (PsiClass)ArraysKt.firstOrNull((Object[])classesByName);
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = bundleName;
                }
                return object;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Nullable
    public PsiClass getResourceBundle() {
        return null;
    }

    @Nullable
    public String getTemplateName() {
        return null;
    }

    @Nullable
    public String getConcatenationTemplateName() {
        return null;
    }

    public boolean canShowJavaCodeInfo() {
        return false;
    }

    public IntelliJProjectResourceBundleManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    public static final /* synthetic */ Project access$getMyProject$p(IntelliJProjectResourceBundleManager $this) {
        return $this.myProject;
    }
}

