/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.renderers;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ui.UIUtil;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LabelPropertyRenderer<V>
extends JLabel
implements PropertyRenderer<V> {
    @Nls
    private String myStaticText;

    public LabelPropertyRenderer() {
        this.setOpaque(true);
        this.putClientProperty("html.disable", true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
    }

    public LabelPropertyRenderer(@Nls String staticText) {
        this();
        this.myStaticText = staticText;
    }

    @Override
    public JLabel getComponent(RadRootContainer rootContainer, V value, boolean selected, boolean hasFocus) {
        this.setText(null);
        this.setIcon(null);
        if (selected) {
            this.setForeground(UIUtil.getTableSelectionForeground());
            this.setBackground(UIUtil.getTableSelectionBackground((boolean)true));
        } else {
            this.setForeground(UIUtil.getTableForeground());
            this.setBackground(UIUtil.getTableBackground());
        }
        if (value != null) {
            this.customize(value);
        }
        return this;
    }

    protected void customize(@NotNull V value) {
        if (value == null) {
            LabelPropertyRenderer.$$$reportNull$$$0(0);
        }
        if (this.myStaticText == null) {
            @NlsSafe String s = value.toString();
            this.setText(s);
        } else {
            this.setText(this.myStaticText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/renderers/LabelPropertyRenderer", "customize"));
    }
}

